/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.metrics;

import io.airlift.stats.DistributionStat;
import io.airlift.stats.TimeStat;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class FileFormatDataSourceStats {
    private final DistributionStat readBytes = new DistributionStat();
    private final DistributionStat maxCombinedBytesPerRow = new DistributionStat();
    private final TimeStat time0Bto100KB = new TimeStat(TimeUnit.MILLISECONDS);
    private final TimeStat time100KBto1MB = new TimeStat(TimeUnit.MILLISECONDS);
    private final TimeStat time1MBto10MB = new TimeStat(TimeUnit.MILLISECONDS);
    private final TimeStat time10MBPlus = new TimeStat(TimeUnit.MILLISECONDS);

    @Managed
    @Nested
    public DistributionStat getReadBytes() {
        return this.readBytes;
    }

    @Managed
    @Nested
    public DistributionStat getMaxCombinedBytesPerRow() {
        return this.maxCombinedBytesPerRow;
    }

    @Managed
    @Nested
    public TimeStat get0Bto100KB() {
        return this.time0Bto100KB;
    }

    @Managed
    @Nested
    public TimeStat get100KBto1MB() {
        return this.time100KBto1MB;
    }

    @Managed
    @Nested
    public TimeStat get1MBto10MB() {
        return this.time1MBto10MB;
    }

    @Managed
    @Nested
    public TimeStat get10MBPlus() {
        return this.time10MBPlus;
    }

    public void readDataBytesPerSecond(long bytes, long nanos) {
        this.readBytes.add(bytes);
        if (bytes < 102400L) {
            this.time0Bto100KB.add((double)nanos, TimeUnit.NANOSECONDS);
        } else if (bytes < 0x100000L) {
            this.time100KBto1MB.add((double)nanos, TimeUnit.NANOSECONDS);
        } else if (bytes < 0xA00000L) {
            this.time1MBto10MB.add((double)nanos, TimeUnit.NANOSECONDS);
        } else {
            this.time10MBPlus.add((double)nanos, TimeUnit.NANOSECONDS);
        }
    }

    public void addMaxCombinedBytesPerRow(long bytes) {
        this.maxCombinedBytesPerRow.add(bytes);
    }
}

