/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.Immutable;
import io.trino.client.ClientTypeSignature;
import io.trino.client.NamedClientTypeSignature;
import io.trino.client.TrinoJsonCodec;
import java.io.IOException;
import java.util.Objects;

@Immutable
@JsonDeserialize(using=ClientTypeSignatureParameterDeserializer.class)
public class ClientTypeSignatureParameter {
    private final ParameterKind kind;
    private final Object value;

    public static ClientTypeSignatureParameter ofType(ClientTypeSignature typeSignature) {
        return new ClientTypeSignatureParameter(ParameterKind.TYPE, typeSignature);
    }

    public static ClientTypeSignatureParameter ofNamedType(NamedClientTypeSignature namedTypeSignature) {
        return new ClientTypeSignatureParameter(ParameterKind.NAMED_TYPE, namedTypeSignature);
    }

    public static ClientTypeSignatureParameter ofLong(long longLiteral) {
        return new ClientTypeSignatureParameter(ParameterKind.LONG, longLiteral);
    }

    @JsonCreator
    public ClientTypeSignatureParameter(@JsonProperty(value="kind") ParameterKind kind, @JsonProperty(value="value") Object value) {
        this.kind = kind;
        this.value = value;
    }

    @JsonProperty
    public ParameterKind getKind() {
        return this.kind;
    }

    @JsonProperty
    public Object getValue() {
        return this.value;
    }

    private <A> A getValue(ParameterKind expectedParameterKind, Class<A> target) {
        if (this.kind != expectedParameterKind) {
            throw new IllegalArgumentException(String.format("ParameterKind is [%s] but expected [%s]", new Object[]{this.kind, expectedParameterKind}));
        }
        return target.cast(this.value);
    }

    public ClientTypeSignature getTypeSignature() {
        return this.getValue(ParameterKind.TYPE, ClientTypeSignature.class);
    }

    public Long getLongLiteral() {
        return this.getValue(ParameterKind.LONG, Long.class);
    }

    public NamedClientTypeSignature getNamedTypeSignature() {
        return this.getValue(ParameterKind.NAMED_TYPE, NamedClientTypeSignature.class);
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientTypeSignatureParameter other = (ClientTypeSignatureParameter)o;
        return this.kind == other.kind && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.value});
    }

    public static enum ParameterKind {
        TYPE,
        NAMED_TYPE,
        LONG,
        VARIABLE;


        @JsonCreator
        public static ParameterKind fromJsonValue(String value) {
            switch (value) {
                case "TYPE_SIGNATURE": {
                    return TYPE;
                }
                case "NAMED_TYPE_SIGNATURE": {
                    return NAMED_TYPE;
                }
                case "LONG_LITERAL": {
                    return LONG;
                }
            }
            return ParameterKind.valueOf(value);
        }
    }

    public static class ClientTypeSignatureParameterDeserializer
    extends JsonDeserializer<ClientTypeSignatureParameter> {
        private static final ObjectMapper MAPPER = TrinoJsonCodec.OBJECT_MAPPER_SUPPLIER.get();

        public ClientTypeSignatureParameter deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            Object value;
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            ParameterKind kind = (ParameterKind)((Object)MAPPER.readValue(MAPPER.treeAsTokens((TreeNode)node.get("kind")), ParameterKind.class));
            JsonParser jsonValue = MAPPER.treeAsTokens((TreeNode)node.get("value"));
            switch (kind.ordinal()) {
                case 0: {
                    value = MAPPER.readValue(jsonValue, ClientTypeSignature.class);
                    break;
                }
                case 1: {
                    value = MAPPER.readValue(jsonValue, NamedClientTypeSignature.class);
                    break;
                }
                case 2: {
                    value = MAPPER.readValue(jsonValue, Long.class);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported kind [%s]", new Object[]{kind}));
                }
            }
            return new ClientTypeSignatureParameter(kind, value);
        }
    }
}

