/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.AbstractIterator;
import com.google.common.io.Closer;
import io.trino.client.CloseableIterator;
import io.trino.client.Column;
import io.trino.client.JsonDecodingUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public final class JsonIterators {
    private static final JsonFactory JSON_FACTORY = JsonIterators.createJsonFactory();

    private JsonIterators() {
    }

    public static CloseableIterator<List<Object>> forJsonParser(JsonParser parser, List<Column> columns) throws IOException {
        return new JsonIterator(parser, JsonDecodingUtils.createTypeDecoders(columns));
    }

    public static CloseableIterator<List<Object>> forInputStream(InputStream stream, JsonDecodingUtils.TypeDecoder[] decoders) throws IOException {
        return new JsonIterator(stream, decoders);
    }

    @SuppressModernizer
    static JsonFactory createJsonFactory() {
        return new JsonFactory().setCodec((ObjectCodec)new ObjectMapper()).enable(JsonParser.Feature.USE_FAST_DOUBLE_PARSER).enable(JsonParser.Feature.USE_FAST_BIG_NUMBER_PARSER).disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
    }

    private static class JsonIterator
    extends AbstractIterator<List<Object>>
    implements CloseableIterator<List<Object>> {
        private final Closer closer = Closer.create();
        private boolean closed;
        private final JsonParser parser;
        private final JsonDecodingUtils.TypeDecoder[] decoders;

        public JsonIterator(JsonParser parser, JsonDecodingUtils.TypeDecoder[] decoders) throws IOException {
            Objects.requireNonNull(decoders, "decoders is null");
            this.parser = Objects.requireNonNull(parser, "parser is null");
            this.decoders = decoders;
            this.closer.register((Closeable)parser);
            Verify.verify((parser.nextToken() == JsonToken.START_ARRAY ? 1 : 0) != 0, (String)"Expected start of an array, but got %s", (Object)parser.currentToken());
            switch (parser.nextToken()) {
                case END_ARRAY: {
                    this.closed = true;
                    break;
                }
                case START_ARRAY: {
                    break;
                }
                default: {
                    throw new VerifyException("Expected start of the data array, but got " + String.valueOf(parser.currentToken()));
                }
            }
        }

        public JsonIterator(InputStream stream, JsonDecodingUtils.TypeDecoder[] decoders) throws IOException {
            this(JSON_FACTORY.createParser(Objects.requireNonNull(stream, "stream is null")), decoders);
            this.closer.register((Closeable)stream);
        }

        private void checkIfClosed() {
            try {
                Verify.verify((this.parser.nextToken() == JsonToken.END_ARRAY ? 1 : 0) != 0, (String)"Expected end of data array, but got %s", (Object)this.parser.currentToken());
                switch (this.parser.nextToken()) {
                    case END_ARRAY: {
                        this.close();
                        break;
                    }
                    case START_ARRAY: {
                        break;
                    }
                    default: {
                        throw new VerifyException("Expected end of or start of next data array, but got " + String.valueOf(this.parser.currentToken()));
                    }
                }
            }
            catch (IOException e) {
                this.closed = true;
                throw new UncheckedIOException(e);
            }
        }

        public List<Object> computeNext() {
            if (this.closed) {
                return (List)this.endOfData();
            }
            try {
                ArrayList<Object> row = new ArrayList<Object>(this.decoders.length);
                for (JsonDecodingUtils.TypeDecoder decoder : this.decoders) {
                    if (Objects.requireNonNull(this.parser.nextToken()) == JsonToken.VALUE_NULL) {
                        row.add(null);
                        continue;
                    }
                    row.add(decoder.decode(this.parser));
                }
                this.checkIfClosed();
                return Collections.unmodifiableList(row);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            this.closer.close();
        }
    }
}

