/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.auth.kerberos;

import com.google.common.collect.Iterables;
import io.trino.client.ClientException;
import io.trino.client.auth.kerberos.AbstractUnconstrainedContextProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Set;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSException;

public class DelegatedUnconstrainedContextProvider
extends AbstractUnconstrainedContextProvider {
    private final Subject subject = DelegatedUnconstrainedContextProvider.current();

    @Override
    protected Subject getSubject() {
        return this.subject;
    }

    @Override
    public void refresh() throws GSSException {
        Set<KerberosTicket> credentials = this.subject.getPrivateCredentials(KerberosTicket.class);
        if (credentials.size() > 1) {
            throw new ClientException("Invalid Credentials. Multiple Kerberos Credentials found.");
        }
        KerberosTicket kerberosTicket = (KerberosTicket)Iterables.getOnlyElement(credentials);
        if (kerberosTicket.isRenewable()) {
            try {
                kerberosTicket.refresh();
            }
            catch (RefreshFailedException exception) {
                throw new ClientException("Unable to refresh the kerberos ticket", exception);
            }
        }
    }

    private static Subject current() {
        try {
            Method current = Subject.class.getDeclaredMethod("current", new Class[0]);
            return (Subject)current.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
            return Subject.getSubject(AccessController.getContext());
        }
    }
}

