/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spooling.filesystem;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.spi.spool.SpoolingManager;
import io.trino.spi.spool.SpoolingManagerContext;
import io.trino.spi.spool.SpoolingManagerFactory;
import io.trino.spooling.filesystem.FileSystemSpoolingModule;
import java.util.Map;
import java.util.Objects;
import org.weakref.jmx.guice.MBeanModule;

public class FileSystemSpoolingManagerFactory
implements SpoolingManagerFactory {
    public String getName() {
        return "filesystem";
    }

    public SpoolingManager create(Map<String, String> config, SpoolingManagerContext context) {
        Objects.requireNonNull(config, "requiredConfig is null");
        Bootstrap app = new Bootstrap(new Module[]{new FileSystemSpoolingModule(context.isCoordinator()), new MBeanModule(), new MBeanServerModule(), binder -> {
            binder.bind(SpoolingManagerContext.class).toInstance((Object)context);
            binder.bind(OpenTelemetry.class).toInstance((Object)context.getOpenTelemetry());
        }});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (SpoolingManager)injector.getInstance(SpoolingManager.class);
    }
}

