/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spooling.filesystem;

import io.azam.ulidj.ULID;
import io.trino.filesystem.Location;
import io.trino.spooling.filesystem.FileSystemLayout;
import io.trino.spooling.filesystem.FileSystemSpooledSegmentHandle;
import java.time.Instant;
import java.util.List;
import java.util.Optional;

public class SimpleFileSystemLayout
implements FileSystemLayout {
    @Override
    public Location location(Location rootLocation, FileSystemSpooledSegmentHandle segmentHandle) {
        return rootLocation.appendPath(segmentHandle.identifier() + "." + segmentHandle.encoding());
    }

    @Override
    public List<Location> searchPaths(Location rootLocation) {
        return List.of(rootLocation);
    }

    @Override
    public Optional<Instant> getExpiration(Location location) {
        String filename = location.fileName();
        int index = filename.indexOf(".");
        if (index == -1) {
            return Optional.empty();
        }
        String uuid = filename.substring(0, index);
        if (!ULID.isValid((CharSequence)uuid)) {
            return Optional.empty();
        }
        return Optional.of(Instant.ofEpochMilli(ULID.getTimestamp((CharSequence)uuid)));
    }
}

