/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spooling.filesystem.encryption;

import io.trino.filesystem.Location;
import io.trino.filesystem.encryption.EncryptionKey;
import io.trino.spooling.filesystem.encryption.AzureEncryptionHeadersTranslator;
import io.trino.spooling.filesystem.encryption.GcsEncryptionHeadersTranslator;
import io.trino.spooling.filesystem.encryption.HeadersUtils;
import io.trino.spooling.filesystem.encryption.S3EncryptionHeadersTranslator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface EncryptionHeadersTranslator {
    public EncryptionKey extractKey(Map<String, List<String>> var1);

    public Map<String, List<String>> createHeaders(EncryptionKey var1);

    public static EncryptionHeadersTranslator encryptionHeadersTranslator(Location location) {
        Objects.requireNonNull(location, "location is null");
        return location.scheme().map(EncryptionHeadersTranslator::forScheme).orElseThrow(() -> new IllegalArgumentException("Unknown location scheme: " + String.valueOf(location)));
    }

    public static EncryptionHeadersTranslator forScheme(String scheme) {
        EncryptionHeadersTranslator schemeHeadersTranslator = switch (scheme) {
            case "s3" -> new S3EncryptionHeadersTranslator();
            case "gs" -> new GcsEncryptionHeadersTranslator();
            case "abfs" -> new AzureEncryptionHeadersTranslator();
            default -> throw new IllegalArgumentException("Unknown file system scheme: " + scheme);
        };
        return new NormalizingHeadersTranslator(schemeHeadersTranslator);
    }

    public static class NormalizingHeadersTranslator
    implements EncryptionHeadersTranslator {
        private final EncryptionHeadersTranslator delegate;

        NormalizingHeadersTranslator(EncryptionHeadersTranslator delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public EncryptionKey extractKey(Map<String, List<String>> headers) {
            return this.delegate.extractKey(HeadersUtils.normalizeHeaders(headers));
        }

        @Override
        public Map<String, List<String>> createHeaders(EncryptionKey encryption) {
            return HeadersUtils.normalizeHeaders(this.delegate.createHeaders(encryption));
        }
    }
}

