/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spooling.filesystem.encryption;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import io.trino.filesystem.encryption.EncryptionKey;
import io.trino.spooling.filesystem.encryption.EncryptionHeadersTranslator;
import io.trino.spooling.filesystem.encryption.HeadersUtils;
import java.util.Base64;
import java.util.List;
import java.util.Map;

class GcsEncryptionHeadersTranslator
implements EncryptionHeadersTranslator {
    GcsEncryptionHeadersTranslator() {
    }

    @Override
    public EncryptionKey extractKey(Map<String, List<String>> headers) {
        byte[] key = Base64.getDecoder().decode(HeadersUtils.getOnlyHeader(headers, "x-goog-encryption-key"));
        String sha256Checksum = HeadersUtils.getOnlyHeader(headers, "x-goog-encryption-key-sha256");
        EncryptionKey encryption = new EncryptionKey(key, HeadersUtils.getOnlyHeader(headers, "x-goog-encryption-algorithm"));
        Preconditions.checkArgument((boolean)GcsEncryptionHeadersTranslator.sha256(encryption).equals(sha256Checksum), (Object)"Key SHA256 checksum does not match");
        return encryption;
    }

    @Override
    public Map<String, List<String>> createHeaders(EncryptionKey encryption) {
        return ImmutableMap.of((Object)"x-goog-encryption-algorithm", (Object)ImmutableList.of((Object)encryption.algorithm()), (Object)"x-goog-encryption-key", (Object)ImmutableList.of((Object)GcsEncryptionHeadersTranslator.encoded(encryption)), (Object)"x-goog-encryption-key-sha256", (Object)ImmutableList.of((Object)GcsEncryptionHeadersTranslator.sha256(encryption)));
    }

    private static String sha256(EncryptionKey key) {
        return Base64.getEncoder().encodeToString(Hashing.sha256().hashBytes(key.key()).asBytes());
    }

    private static String encoded(EncryptionKey key) {
        return Base64.getEncoder().encodeToString(key.key());
    }
}

