/*
 * Decompiled with CFR 0.152.
 */
package io.azam.ulidj;

import io.azam.ulidj.ULID;
import java.security.SecureRandom;
import java.util.Random;

public class MonotonicULID {
    private final Random random;
    private long lastTimestamp;
    private byte[] lastEntropy;

    public MonotonicULID() {
        this(new SecureRandom());
    }

    public MonotonicULID(Random random) {
        if (random == null) {
            throw new IllegalArgumentException("java.util.Random instance must not be null");
        }
        this.random = random;
        this.lastEntropy = new byte[10];
        this.lastTimestamp = -1L;
    }

    public synchronized String generate() {
        long now = System.currentTimeMillis();
        if (now == this.lastTimestamp) {
            boolean carry = true;
            for (int i = 9; i >= 0; --i) {
                if (!carry) continue;
                byte work = this.lastEntropy[i];
                work = (byte)(work + 1);
                carry = this.lastEntropy[i] == -1 && carry;
                this.lastEntropy[i] = work;
            }
            if (carry) {
                throw new IllegalStateException("ULID entropy overflowed for same millisecond");
            }
        } else {
            this.lastTimestamp = now;
            this.random.nextBytes(this.lastEntropy);
        }
        return ULID.generate(this.lastTimestamp, this.lastEntropy);
    }

    public synchronized byte[] generateBinary() {
        long now = System.currentTimeMillis();
        if (now == this.lastTimestamp) {
            boolean carry = true;
            for (int i = 9; i >= 0; --i) {
                if (!carry) continue;
                byte work = this.lastEntropy[i];
                work = (byte)(work + 1);
                carry = this.lastEntropy[i] == -1 && carry;
                this.lastEntropy[i] = work;
            }
            if (carry) {
                throw new IllegalStateException("ULID entropy overflowed for same millisecond");
            }
        } else {
            this.lastTimestamp = now;
            this.random.nextBytes(this.lastEntropy);
        }
        return ULID.generateBinary(this.lastTimestamp, this.lastEntropy);
    }
}

