/*
 * Decompiled with CFR 0.152.
 */
package io.trino.re2j;

final class DFAState {
    public static final DFAState DEAD_STATE = new DFAState(StateType.DEAD);
    private final StateType type;
    private final int[] instIndexes;
    private final int flag;
    private final DFAState[] next = new DFAState[256];

    public DFAState(int[] instIndexes, int nIndexes, int flag) {
        this.type = StateType.REGULAR;
        this.instIndexes = new int[nIndexes];
        System.arraycopy(instIndexes, 0, this.instIndexes, 0, nIndexes);
        this.flag = flag;
    }

    private DFAState(StateType type) {
        this.type = type;
        this.instIndexes = new int[0];
        this.flag = 0;
    }

    public StateType getType() {
        return this.type;
    }

    public int getFlag() {
        return this.flag;
    }

    public int[] getInstIndexes() {
        return this.instIndexes;
    }

    public boolean isMatch() {
        return (this.flag & 0x100) != 0;
    }

    public boolean isDead() {
        return this.type == StateType.DEAD;
    }

    public DFAState getNextState(byte b) {
        return this.next[b & 0xFF];
    }

    public void setNextState(byte b, DFAState state) {
        this.next[b & 0xFF] = state;
    }

    public static enum StateType {
        DEAD,
        REGULAR;

    }
}

