/*
 * Decompiled with CFR 0.152.
 */
package io.trino.re2j;

class SparseSet {
    private final int[] dense;
    private final int[] sparse;
    private int size;

    SparseSet(int n) {
        this.sparse = new int[n];
        this.dense = new int[n];
    }

    boolean contains(int i) {
        return this.sparse[i] < this.size && this.dense[this.sparse[i]] == i;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    void add(int i) {
        this.dense[this.size] = i;
        this.sparse[i] = this.size++;
    }

    void clear() {
        this.size = 0;
    }

    int getValueAt(int i) {
        if (i >= this.size) {
            throw new IndexOutOfBoundsException(String.format("Cannot get index %d.  SparseSet is size %d", i, this.size));
        }
        return this.dense[i];
    }

    int getSize() {
        return this.size;
    }
}

