/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cache;

import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class CacheUtils {
    private CacheUtils() {
    }

    public static <K, V> V uncheckedCacheGet(Cache<K, V> cache, K key, Supplier<V> loader) {
        try {
            return (V)cache.get(key, loader::get);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Unexpected checked exception from cache load", e);
        }
    }

    public static <K> void invalidateAllIf(Cache<K, ?> cache, Predicate<? super K> filterFunction) {
        List cacheKeys = (List)cache.asMap().keySet().stream().filter(filterFunction).collect(ImmutableList.toImmutableList());
        cache.invalidateAll((Iterable)cacheKeys);
    }
}

