/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import io.trino.filesystem.Locations;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;

public final class Location {
    private static final Splitter SCHEME_SPLITTER = Splitter.on((String)":").limit(2);
    private static final Splitter USER_INFO_SPLITTER = Splitter.on((char)'@').limit(2);
    private static final Splitter AUTHORITY_SPLITTER = Splitter.on((char)'/').limit(2);
    private static final Splitter HOST_AND_PORT_SPLITTER = Splitter.on((char)':').limit(2);
    private final String location;
    private final Optional<String> scheme;
    private final Optional<String> userInfo;
    private final Optional<String> host;
    private final OptionalInt port;
    private final String path;

    public static Location of(String location) {
        Objects.requireNonNull(location, "location is null");
        Preconditions.checkArgument((!location.isEmpty() ? 1 : 0) != 0, (Object)"location is empty");
        Preconditions.checkArgument((!location.isBlank() ? 1 : 0) != 0, (Object)"location is blank");
        if (location.startsWith("/")) {
            return new Location(location, Optional.empty(), Optional.empty(), Optional.empty(), OptionalInt.empty(), location.substring(1));
        }
        List schemeSplit = SCHEME_SPLITTER.splitToList((CharSequence)location);
        Preconditions.checkArgument((schemeSplit.size() == 2 ? 1 : 0) != 0, (String)"No scheme for file system location: %s", (Object)location);
        String scheme = (String)schemeSplit.get(0);
        String afterScheme = (String)schemeSplit.get(1);
        if (afterScheme.startsWith("//")) {
            List authoritySplit = AUTHORITY_SPLITTER.splitToList((CharSequence)(afterScheme = afterScheme.substring(2)));
            List userInfoSplit = USER_INFO_SPLITTER.splitToList((CharSequence)authoritySplit.get(0));
            Optional<String> userInfo = userInfoSplit.size() == 2 ? Optional.of((String)userInfoSplit.get(0)) : Optional.empty();
            List hostAndPortSplit = HOST_AND_PORT_SPLITTER.splitToList((CharSequence)Iterables.getLast((Iterable)userInfoSplit));
            Optional<String> host = Optional.of((String)hostAndPortSplit.get(0)).filter(Predicate.not(String::isEmpty));
            OptionalInt port = OptionalInt.empty();
            if (hostAndPortSplit.size() == 2) {
                try {
                    port = OptionalInt.of(Integer.parseInt((String)hostAndPortSplit.get(1)));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid port in file system location: " + location, e);
                }
            }
            if (!Locations.isS3Tables(location)) {
                Preconditions.checkArgument((userInfo.isEmpty() && host.isEmpty() && port.isEmpty() || authoritySplit.size() == 2 ? 1 : 0) != 0, (String)"Path missing in file system location: %s", (Object)location);
            }
            String path = authoritySplit.size() == 2 ? (String)authoritySplit.get(1) : "";
            return new Location(location, Optional.of(scheme), userInfo, host, port, path);
        }
        Preconditions.checkArgument((boolean)afterScheme.startsWith("/"), (Object)"Path must begin with a '/' when no authority is present");
        return new Location(location, Optional.of(scheme), Optional.empty(), Optional.empty(), OptionalInt.empty(), afterScheme.substring(1));
    }

    private Location(String location, Optional<String> scheme, Optional<String> userInfo, Optional<String> host, OptionalInt port, String path) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.scheme = Objects.requireNonNull(scheme, "scheme is null");
        this.userInfo = Objects.requireNonNull(userInfo, "userInfo is null");
        this.host = Objects.requireNonNull(host, "host is null");
        this.port = Objects.requireNonNull(port, "port is null");
        this.path = Objects.requireNonNull(path, "path is null");
        Preconditions.checkArgument((scheme.isEmpty() || !scheme.get().isEmpty() ? 1 : 0) != 0, (Object)"scheme value is empty");
        Preconditions.checkArgument((host.isEmpty() || !host.get().isEmpty() ? 1 : 0) != 0, (Object)"host value is empty");
    }

    private Location withPath(String location, String path) {
        return new Location(location, this.scheme, this.userInfo, this.host, this.port, path);
    }

    public Optional<String> scheme() {
        return this.scheme;
    }

    public Optional<String> userInfo() {
        return this.userInfo;
    }

    public Optional<String> host() {
        return this.host;
    }

    public OptionalInt port() {
        return this.port;
    }

    public String path() {
        return this.path;
    }

    public String fileName() {
        this.verifyValidFileLocation();
        return this.path.substring(this.path.lastIndexOf(47) + 1);
    }

    public Location sibling(String name) {
        Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name is empty");
        this.verifyValidFileLocation();
        return this.withPath(this.location.substring(0, this.location.lastIndexOf(47) + 1) + name, this.path.substring(0, this.path.lastIndexOf(47) + 1) + name);
    }

    public Location parentDirectory() {
        this.verifyValidFileLocation();
        Preconditions.checkState((!this.path.isEmpty() && !this.path.equals("/") ? 1 : 0) != 0, (String)"root location does not have parent: %s", (Object)this.location);
        int lastIndexOfSlash = this.path.lastIndexOf(47);
        if (lastIndexOfSlash < 0) {
            Object newLocation = this.location.substring(0, this.location.length() - this.path.length() - 1);
            newLocation = (String)newLocation + "/";
            return this.withPath((String)newLocation, "");
        }
        String newPath = this.path.substring(0, lastIndexOfSlash);
        String newLocation = this.location.substring(0, this.location.length() - (this.path.length() - newPath.length()));
        return this.withPath(newLocation, newPath);
    }

    public Location appendPath(String newPathElement) {
        Preconditions.checkArgument((!((String)newPathElement).isEmpty() ? 1 : 0) != 0, (Object)"newPathElement is empty");
        Preconditions.checkArgument((!((String)newPathElement).startsWith("/") ? 1 : 0) != 0, (String)"newPathElement starts with a slash: %s", (Object)newPathElement);
        if (this.path.isEmpty()) {
            return this.appendToEmptyPath((String)newPathElement);
        }
        if (!this.path.endsWith("/")) {
            newPathElement = "/" + (String)newPathElement;
        }
        return this.withPath(this.location + (String)newPathElement, this.path + (String)newPathElement);
    }

    Location removeOneTrailingSlash() {
        if (this.path.endsWith("/")) {
            return this.withPath(this.location.substring(0, this.location.length() - 1), this.path.substring(0, this.path.length() - 1));
        }
        if (this.path.equals("") && this.location.endsWith("/")) {
            return this.withPath(this.location.substring(0, this.location.length() - 1), "");
        }
        return this;
    }

    public Location appendSuffix(String suffix) {
        if (this.path.isEmpty()) {
            return this.appendToEmptyPath(suffix);
        }
        return this.withPath(this.location + suffix, this.path + suffix);
    }

    private Location appendToEmptyPath(String value) {
        boolean needSlash;
        Preconditions.checkState((boolean)this.path.isEmpty());
        boolean bl = needSlash = !this.location.endsWith("/");
        if (this.scheme.isPresent() && this.host.isEmpty() && this.userInfo.isEmpty() && !this.location.endsWith(":///")) {
            needSlash = true;
        }
        return this.withPath(this.location + (needSlash ? "/" : "") + value, value);
    }

    public void verifyValidFileLocation() {
        Preconditions.checkState((!this.path.isEmpty() && !this.path.equals("/") ? 1 : 0) != 0, (String)"File location must contain a path: %s", (Object)this.location);
        Preconditions.checkState((!this.path.endsWith("/") ? 1 : 0) != 0, (String)"File location cannot end with '/': %s", (Object)this.location);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof Location)) return false;
        Location that = (Location)o;
        if (!this.location.equals(that.location)) return false;
        return true;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public String toString() {
        return this.location;
    }
}

