/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.tracing;

import io.airlift.slice.Slice;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.tracing.FileSystemAttributes;
import io.trino.filesystem.tracing.Tracing;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

final class TracingInput
implements TrinoInput {
    private final Tracer tracer;
    private final TrinoInput delegate;
    private final Location location;
    private final Optional<Long> fileLength;

    public TracingInput(Tracer tracer, TrinoInput delegate, Location location, Optional<Long> fileLength) {
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.location = Objects.requireNonNull(location, "location is null");
        this.fileLength = Objects.requireNonNull(fileLength, "fileLength is null");
    }

    @Override
    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        Span span = this.spanBuilder("Input.readFully", bufferLength).setAttribute(FileSystemAttributes.FILE_READ_POSITION, (Object)position).startSpan();
        Tracing.withTracing(span, () -> this.delegate.readFully(position, buffer, bufferOffset, bufferLength));
    }

    @Override
    public int readTail(byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        Span span = this.spanBuilder("Input.readTail", bufferLength).startSpan();
        return Tracing.withTracing(span, () -> this.delegate.readTail(buffer, bufferOffset, bufferLength));
    }

    @Override
    public Slice readFully(long position, int length) throws IOException {
        Span span = this.spanBuilder("Input.readFully", length).setAttribute(FileSystemAttributes.FILE_READ_POSITION, (Object)position).startSpan();
        return Tracing.withTracing(span, () -> this.delegate.readFully(position, length));
    }

    @Override
    public Slice readTail(int length) throws IOException {
        Span span = this.spanBuilder("Input.readTail", length).startSpan();
        return Tracing.withTracing(span, () -> this.delegate.readTail(length));
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public String toString() {
        return this.location.toString();
    }

    private SpanBuilder spanBuilder(String name, long readLength) {
        return this.tracer.spanBuilder(name).setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)this.toString()).setAllAttributes(Tracing.attribute(FileSystemAttributes.FILE_SIZE, this.fileLength)).setAttribute(FileSystemAttributes.FILE_READ_SIZE, (Object)readLength);
    }
}

