/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.functions.python;

import com.google.common.base.CharMatcher;
import io.airlift.log.Logger;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

final class LoggingOutputStream
extends ByteArrayOutputStream {
    private final Logger logger;

    public LoggingOutputStream(Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger is null");
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.logger.isDebugEnabled()) {
            super.write(b, off, len);
            this.flush();
        }
    }

    @Override
    public void flush() {
        int index;
        if (this.count > 4096) {
            this.log(this.toString(StandardCharsets.UTF_8));
            this.reset();
            return;
        }
        for (index = this.count - 1; index >= 0 && this.buf[index] != 10; --index) {
        }
        if (index == -1) {
            return;
        }
        String data = new String(this.buf, 0, index, StandardCharsets.UTF_8);
        data.lines().forEach(this::log);
        int remaining = this.count - index - 1;
        System.arraycopy(this.buf, index + 1, this.buf, 0, remaining);
        this.count = remaining;
    }

    @Override
    public void close() {
        this.log(this.toString(StandardCharsets.UTF_8));
        this.reset();
    }

    private void log(String message) {
        String value = CharMatcher.javaIsoControl().removeFrom((CharSequence)message).strip();
        if (!value.isEmpty()) {
            this.logger.debug(value);
        }
    }
}

