/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.concurrent.AsyncSemaphore;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.trino.plugin.exchange.filesystem.FileStatus;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeSinkHandle;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeSinkInstanceHandle;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeSourceHandle;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeStats;
import io.trino.plugin.exchange.filesystem.FileSystemExchangeStorage;
import io.trino.spi.exchange.Exchange;
import io.trino.spi.exchange.ExchangeContext;
import io.trino.spi.exchange.ExchangeId;
import io.trino.spi.exchange.ExchangeSinkHandle;
import io.trino.spi.exchange.ExchangeSinkInstanceHandle;
import io.trino.spi.exchange.ExchangeSourceHandle;
import io.trino.spi.exchange.ExchangeSourceHandleSource;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileSystemExchange
implements Exchange {
    private static final Pattern PARTITION_FILE_NAME_PATTERN = Pattern.compile("(\\d+)_(\\d+)\\.data");
    private static final char[] RANDOMIZED_HEX_PREFIX_ALPHABET = "abcdef0123456789".toCharArray();
    private static final int RANDOMIZED_HEX_PREFIX_LENGTH = 6;
    private final List<URI> baseDirectories;
    private final FileSystemExchangeStorage exchangeStorage;
    private final FileSystemExchangeStats stats;
    private final Span exchangeSpan;
    private final ExchangeContext exchangeContext;
    private final int outputPartitionCount;
    private final boolean preserveOrderWithinPartition;
    private final int fileListingParallelism;
    private final long exchangeSourceHandleTargetDataSizeInBytes;
    private final ExecutorService executor;
    private final Map<Integer, URI> outputDirectories = new ConcurrentHashMap<Integer, URI>();
    @GuardedBy(value="this")
    private final Set<Integer> allSinks = new HashSet<Integer>();
    @GuardedBy(value="this")
    private final Map<Integer, Integer> finishedSinks = new HashMap<Integer, Integer>();
    @GuardedBy(value="this")
    private boolean noMoreSinks;
    @GuardedBy(value="this")
    private boolean exchangeSourceHandlesCreationStarted;
    private final CompletableFuture<List<ExchangeSourceHandle>> exchangeSourceHandlesFuture = new CompletableFuture();

    public FileSystemExchange(List<URI> baseDirectories, FileSystemExchangeStorage exchangeStorage, FileSystemExchangeStats stats, Tracer tracer, ExchangeContext exchangeContext, int outputPartitionCount, boolean preserveOrderWithinPartition, int fileListingParallelism, long exchangeSourceHandleTargetDataSizeInBytes, ExecutorService executor) {
        ArrayList directories = new ArrayList(Objects.requireNonNull(baseDirectories, "baseDirectories is null"));
        Collections.shuffle(directories);
        this.baseDirectories = ImmutableList.copyOf(directories);
        this.exchangeStorage = Objects.requireNonNull(exchangeStorage, "exchangeStorage is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.exchangeContext = Objects.requireNonNull(exchangeContext, "exchangeContext is null");
        this.exchangeSpan = tracer.spanBuilder("exchange").setParent(Context.current().with((ImplicitContextKeyed)exchangeContext.getParentSpan())).setAttribute("ExchangeId", exchangeContext.getExchangeId().getId()).setAttribute("PartitionCount", (long)outputPartitionCount).setAttribute("PreserveOrderWithinPartition", Boolean.toString(preserveOrderWithinPartition)).startSpan();
        this.outputPartitionCount = outputPartitionCount;
        this.preserveOrderWithinPartition = preserveOrderWithinPartition;
        this.fileListingParallelism = fileListingParallelism;
        this.exchangeSourceHandleTargetDataSizeInBytes = exchangeSourceHandleTargetDataSizeInBytes;
        this.executor = Objects.requireNonNull(executor, "executor is null");
    }

    public ExchangeId getId() {
        return this.exchangeContext.getExchangeId();
    }

    public synchronized ExchangeSinkHandle addSink(int taskPartition) {
        FileSystemExchangeSinkHandle sinkHandle = new FileSystemExchangeSinkHandle(taskPartition);
        this.allSinks.add(taskPartition);
        return sinkHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noMoreSinks() {
        FileSystemExchange fileSystemExchange = this;
        synchronized (fileSystemExchange) {
            this.noMoreSinks = true;
        }
    }

    public CompletableFuture<ExchangeSinkInstanceHandle> instantiateSink(ExchangeSinkHandle sinkHandle, int taskAttemptId) {
        FileSystemExchangeSinkHandle fileSystemExchangeSinkHandle = (FileSystemExchangeSinkHandle)sinkHandle;
        int taskPartitionId = fileSystemExchangeSinkHandle.getPartitionId();
        URI outputDirectory = this.getTaskOutputDirectory(taskPartitionId).resolve(taskAttemptId + "/");
        try {
            this.exchangeStorage.createDirectories(outputDirectory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return CompletableFuture.completedFuture(new FileSystemExchangeSinkInstanceHandle(fileSystemExchangeSinkHandle, outputDirectory, this.outputPartitionCount, this.preserveOrderWithinPartition));
    }

    public CompletableFuture<ExchangeSinkInstanceHandle> updateSinkInstanceHandle(ExchangeSinkHandle sinkHandle, int taskAttemptId) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sinkFinished(ExchangeSinkHandle handle, int taskAttemptId) {
        FileSystemExchange fileSystemExchange = this;
        synchronized (fileSystemExchange) {
            FileSystemExchangeSinkHandle sinkHandle = (FileSystemExchangeSinkHandle)handle;
            this.finishedSinks.putIfAbsent(sinkHandle.getPartitionId(), taskAttemptId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allRequiredSinksFinished() {
        ListenableFuture exchangeSourceHandlesCreationFuture;
        Verify.verify((!Thread.holdsLock(this) ? 1 : 0) != 0);
        FileSystemExchange fileSystemExchange = this;
        synchronized (fileSystemExchange) {
            if (this.exchangeSourceHandlesCreationStarted) {
                return;
            }
            Verify.verify((boolean)this.noMoreSinks, (String)"noMoreSinks is expected to be set", (Object[])new Object[0]);
            this.exchangeSourceHandlesCreationStarted = true;
            exchangeSourceHandlesCreationFuture = this.stats.getCreateExchangeSourceHandles().record(this::createExchangeSourceHandles);
        }
        Futures.addCallback((ListenableFuture)exchangeSourceHandlesCreationFuture, (FutureCallback)new FutureCallback<List<ExchangeSourceHandle>>(){

            public void onSuccess(List<ExchangeSourceHandle> exchangeSourceHandles) {
                FileSystemExchange.this.exchangeSourceHandlesFuture.complete(exchangeSourceHandles);
            }

            public void onFailure(Throwable throwable) {
                FileSystemExchange.this.exchangeSourceHandlesFuture.completeExceptionally(throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture<List<ExchangeSourceHandle>> createExchangeSourceHandles() {
        List committedTaskAttempts;
        FileSystemExchange fileSystemExchange = this;
        synchronized (fileSystemExchange) {
            committedTaskAttempts = (List)this.finishedSinks.entrySet().stream().map(entry -> new CommittedTaskAttempt((Integer)entry.getKey(), (Integer)entry.getValue())).collect(ImmutableList.toImmutableList());
        }
        return Futures.transform((ListenableFuture)AsyncSemaphore.processAll((List)committedTaskAttempts, this::getCommittedPartitions, (int)this.fileListingParallelism, (Executor)this.executor), partitionsList -> {
            ArrayListMultimap sourceFiles = ArrayListMultimap.create();
            partitionsList.forEach(arg_0 -> FileSystemExchange.lambda$createExchangeSourceHandles$1((Multimap)sourceFiles, arg_0));
            ImmutableList.Builder result = ImmutableList.builder();
            for (Integer partitionId : sourceFiles.keySet()) {
                Collection files = sourceFiles.get((Object)partitionId);
                long currentExchangeHandleDataSizeInBytes = 0L;
                ImmutableList.Builder currentExchangeHandleFiles = ImmutableList.builder();
                for (FileSystemExchangeSourceHandle.SourceFile file : files) {
                    if (currentExchangeHandleDataSizeInBytes > 0L && currentExchangeHandleDataSizeInBytes + file.getFileSize() > this.exchangeSourceHandleTargetDataSizeInBytes) {
                        result.add((Object)new FileSystemExchangeSourceHandle(this.exchangeContext.getExchangeId(), partitionId, (List<FileSystemExchangeSourceHandle.SourceFile>)currentExchangeHandleFiles.build()));
                        currentExchangeHandleDataSizeInBytes = 0L;
                        currentExchangeHandleFiles = ImmutableList.builder();
                    }
                    currentExchangeHandleDataSizeInBytes += file.getFileSize();
                    currentExchangeHandleFiles.add((Object)file);
                }
                if (currentExchangeHandleDataSizeInBytes <= 0L) continue;
                result.add((Object)new FileSystemExchangeSourceHandle(this.exchangeContext.getExchangeId(), partitionId, (List<FileSystemExchangeSourceHandle.SourceFile>)currentExchangeHandleFiles.build()));
            }
            return result.build();
        }, (Executor)this.executor);
    }

    private ListenableFuture<Multimap<Integer, FileSystemExchangeSourceHandle.SourceFile>> getCommittedPartitions(CommittedTaskAttempt committedTaskAttempt) {
        URI sinkOutputPath = this.getTaskOutputDirectory(committedTaskAttempt.partitionId());
        return this.stats.getGetCommittedPartitions().record(Futures.transform(this.exchangeStorage.listFilesRecursively(sinkOutputPath), sinkOutputFiles -> {
            List committedMarkerFilePaths = (List)sinkOutputFiles.stream().map(FileStatus::getFilePath).filter(filePath -> filePath.endsWith("committed")).collect(ImmutableList.toImmutableList());
            if (committedMarkerFilePaths.isEmpty()) {
                throw new IllegalStateException(String.format("No committed attempts found under sink output path %s", sinkOutputPath));
            }
            for (String committedMarkerFilePath : committedMarkerFilePaths) {
                String[] parts = committedMarkerFilePath.split("/");
                Preconditions.checkState((parts.length >= 3 ? 1 : 0) != 0, (String)"committedMarkerFilePath %s is malformed", (Object)committedMarkerFilePath);
                String stringCommittedAttemptId = parts[parts.length - 2];
                if (Integer.parseInt(stringCommittedAttemptId) != committedTaskAttempt.attemptId()) continue;
                int attemptIdOffset = committedMarkerFilePath.length() - stringCommittedAttemptId.length() - "/".length() - "committed".length();
                List partitionFiles = (List)sinkOutputFiles.stream().filter(file -> file.getFilePath().startsWith(stringCommittedAttemptId + "/", attemptIdOffset) && file.getFilePath().endsWith(".data")).collect(ImmutableList.toImmutableList());
                ImmutableMultimap.Builder result = ImmutableMultimap.builder();
                for (FileStatus partitionFile : partitionFiles) {
                    Matcher matcher = PARTITION_FILE_NAME_PATTERN.matcher(new File(partitionFile.getFilePath()).getName());
                    Preconditions.checkState((boolean)matcher.matches(), (String)"Unexpected partition file: %s", (Object)partitionFile);
                    int partitionId = Integer.parseInt(matcher.group(1));
                    result.put((Object)partitionId, (Object)new FileSystemExchangeSourceHandle.SourceFile(partitionFile.getFilePath(), partitionFile.getFileSize(), committedTaskAttempt.partitionId(), committedTaskAttempt.attemptId()));
                }
                return result.build();
            }
            throw new IllegalArgumentException("committed attempt %s for task %s not found".formatted(committedTaskAttempt.attemptId(), committedTaskAttempt.partitionId()));
        }, (Executor)this.executor));
    }

    private URI getTaskOutputDirectory(int taskPartitionId) {
        return this.outputDirectories.computeIfAbsent(taskPartitionId, n -> this.baseDirectories.get(ThreadLocalRandom.current().nextInt(this.baseDirectories.size())).resolve(FileSystemExchange.generateRandomizedHexPrefix() + "." + String.valueOf(this.exchangeContext.getQueryId()) + "." + String.valueOf(this.exchangeContext.getExchangeId()) + "." + taskPartitionId + "/"));
    }

    public ExchangeSourceHandleSource getSourceHandles() {
        return new ExchangeSourceHandleSource(){

            public CompletableFuture<ExchangeSourceHandleSource.ExchangeSourceHandleBatch> getNextBatch() {
                return FileSystemExchange.this.exchangeSourceHandlesFuture.thenApply(handles -> new ExchangeSourceHandleSource.ExchangeSourceHandleBatch(handles, true));
            }

            public void close() {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ImmutableList toDelete;
        FileSystemExchange fileSystemExchange = this;
        synchronized (fileSystemExchange) {
            toDelete = (ImmutableList)this.allSinks.stream().map(this::getTaskOutputDirectory).collect(ImmutableList.toImmutableList());
        }
        this.stats.getCloseExchange().record(this.exchangeStorage.deleteRecursively((List<URI>)toDelete));
        this.exchangeSpan.end();
    }

    private static String generateRandomizedHexPrefix() {
        char[] value = new char[6];
        for (int i = 0; i < value.length; ++i) {
            value[i] = RANDOMIZED_HEX_PREFIX_ALPHABET[ThreadLocalRandom.current().nextInt(RANDOMIZED_HEX_PREFIX_ALPHABET.length)];
        }
        return new String(value);
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("baseDirectories", this.baseDirectories).add("exchangeStorage", (Object)this.exchangeStorage.getClass().getName()).add("exchangeContext", (Object)this.exchangeContext).add("outputPartitionCount", this.outputPartitionCount).add("preserveOrderWithinPartition", this.preserveOrderWithinPartition).add("fileListingParallelism", this.fileListingParallelism).add("exchangeSourceHandleTargetDataSizeInBytes", this.exchangeSourceHandleTargetDataSizeInBytes).add("outputDirectories", this.outputDirectories).add("allSinks", this.allSinks).add("finishedSinks", this.finishedSinks).add("noMoreSinks", this.noMoreSinks).add("exchangeSourceHandlesCreationStarted", this.exchangeSourceHandlesCreationStarted).add("exchangeSourceHandlesFuture", this.exchangeSourceHandlesFuture).toString();
    }

    private static /* synthetic */ void lambda$createExchangeSourceHandles$1(Multimap sourceFiles, Multimap partitions) {
        partitions.forEach((arg_0, arg_1) -> ((Multimap)sourceFiles).put(arg_0, arg_1));
    }

    private record CommittedTaskAttempt(int partitionId, int attemptId) {
        public CommittedTaskAttempt {
            Preconditions.checkArgument((partitionId >= 0 ? 1 : 0) != 0, (String)"partitionId is expected to be greater than or equal to zero: %s", (int)partitionId);
            Preconditions.checkArgument((attemptId >= 0 ? 1 : 0) != 0, (String)"attemptId is expected to be greater than or equal to zero: %s", (int)attemptId);
        }
    }
}

