/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.azure;

import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import com.google.inject.Inject;
import io.trino.filesystem.azure.AzureAuth;
import io.trino.filesystem.azure.AzureAuthAccessKeyConfig;
import java.util.Objects;

public final class AzureAuthAccessKey
implements AzureAuth {
    private final String accessKey;

    @Inject
    public AzureAuthAccessKey(AzureAuthAccessKeyConfig config) {
        this(config.getAccessKey());
    }

    public AzureAuthAccessKey(String accessKey) {
        this.accessKey = Objects.requireNonNull(accessKey, "accessKey is null");
    }

    @Override
    public void setAuth(String storageAccount, BlobContainerClientBuilder builder) {
        builder.credential(new StorageSharedKeyCredential(storageAccount, this.accessKey));
    }

    @Override
    public void setAuth(String storageAccount, DataLakeServiceClientBuilder builder) {
        builder.credential(new StorageSharedKeyCredential(storageAccount, this.accessKey));
    }
}

