/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.azure;

import com.azure.core.exception.AzureException;
import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.file.datalake.models.CustomerProvidedKey;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import io.trino.filesystem.TrinoFileSystemException;
import io.trino.filesystem.azure.AzureLocation;
import io.trino.filesystem.encryption.EncryptionKey;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

final class AzureUtils {
    private AzureUtils() {
    }

    public static IOException handleAzureException(RuntimeException exception, String action, AzureLocation location) throws IOException {
        if (AzureUtils.isFileNotFoundException(exception)) {
            throw AzureUtils.withCause(new FileNotFoundException(location.toString()), exception);
        }
        if (exception instanceof AzureException) {
            throw new TrinoFileSystemException("Azure service error %s file: %s".formatted(action, location), (Throwable)exception);
        }
        throw new IOException("Error %s file: %s".formatted(action, location), exception);
    }

    public static boolean isFileNotFoundException(RuntimeException exception) {
        if (exception instanceof BlobStorageException) {
            BlobStorageException blobStorageException = (BlobStorageException)((Object)exception);
            return BlobErrorCode.BLOB_NOT_FOUND.equals((Object)blobStorageException.getErrorCode());
        }
        if (exception instanceof DataLakeStorageException) {
            DataLakeStorageException dataLakeStorageException = (DataLakeStorageException)((Object)exception);
            return "PathNotFound".equals(dataLakeStorageException.getErrorCode());
        }
        return false;
    }

    private static <T extends Throwable> T withCause(T throwable, Throwable cause) {
        throwable.initCause(cause);
        return throwable;
    }

    public static CustomerProvidedKey lakeCustomerProvidedKey(EncryptionKey key) {
        return new CustomerProvidedKey(AzureUtils.encodedKey(key));
    }

    public static com.azure.storage.blob.models.CustomerProvidedKey blobCustomerProvidedKey(EncryptionKey key) {
        return new com.azure.storage.blob.models.CustomerProvidedKey(AzureUtils.encodedKey(key));
    }

    public static String encodedKey(EncryptionKey key) {
        return Base64.getEncoder().encodeToString(key.key());
    }

    public static String keySha256Checksum(EncryptionKey key) {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            byte[] hash = sha256.digest(key.key());
            return Base64.getEncoder().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

