/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.db;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import java.util.Objects;

public final class SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> {
    private static final AttributeKey<String> DB_SQL_TABLE = AttributeKey.stringKey((String)"db.sql.table");
    final SqlClientAttributesGetter<REQUEST, RESPONSE> getter;
    AttributeKey<String> oldSemconvTableAttribute = DB_SQL_TABLE;
    boolean statementSanitizationEnabled = true;

    SqlClientAttributesExtractorBuilder(SqlClientAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> setTableAttribute(AttributeKey<String> oldSemconvTableAttribute) {
        this.oldSemconvTableAttribute = Objects.requireNonNull(oldSemconvTableAttribute);
        return this;
    }

    @CanIgnoreReturnValue
    public SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> setStatementSanitizationEnabled(boolean statementSanitizationEnabled) {
        this.statementSanitizationEnabled = statementSanitizationEnabled;
        return this;
    }

    public AttributesExtractor<REQUEST, RESPONSE> build() {
        return new SqlClientAttributesExtractor<REQUEST, RESPONSE>(this.getter, this.oldSemconvTableAttribute, this.statementSanitizationEnabled);
    }
}

