/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.inject.Inject;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.block.BlockSerdeUtil;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncodingSerde;
import java.io.IOException;
import java.util.Objects;

public final class BlockJsonSerde {
    private BlockJsonSerde() {
    }

    public static class Deserializer
    extends JsonDeserializer<Block> {
        private final BlockEncodingSerde blockEncodingSerde;

        @Inject
        public Deserializer(BlockEncodingSerde blockEncodingSerde) {
            this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        }

        public Block deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            byte[] decoded = jsonParser.getBinaryValue(Base64Variants.MIME_NO_LINEFEEDS);
            return BlockSerdeUtil.readBlock(this.blockEncodingSerde, Slices.wrappedBuffer((byte[])decoded));
        }
    }

    public static class Serializer
    extends JsonSerializer<Block> {
        private final BlockEncodingSerde blockEncodingSerde;

        @Inject
        public Serializer(BlockEncodingSerde blockEncodingSerde) {
            this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        }

        public void serialize(Block block, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            DynamicSliceOutput output = new DynamicSliceOutput(Math.toIntExact(this.blockEncodingSerde.estimatedWriteSize(block)));
            BlockSerdeUtil.writeBlock(this.blockEncodingSerde, (SliceOutput)output, block);
            Slice slice = output.slice();
            jsonGenerator.writeBinary(Base64Variants.MIME_NO_LINEFEEDS, slice.byteArray(), slice.byteArrayOffset(), slice.length());
        }
    }
}

