/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.base.Preconditions;
import io.trino.connector.CatalogServiceProvider;
import io.trino.connector.ConnectorServices;
import io.trino.connector.ConnectorServicesProvider;
import io.trino.spi.connector.CatalogHandle;
import java.util.Objects;
import java.util.function.Function;

public class ConnectorCatalogServiceProvider<T>
implements CatalogServiceProvider<T> {
    private final String name;
    private final ConnectorServicesProvider connectorServicesProvider;
    private final Function<ConnectorServices, T> serviceGetter;

    public ConnectorCatalogServiceProvider(String name, ConnectorServicesProvider connectorServicesProvider, Function<ConnectorServices, T> serviceGetter) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.connectorServicesProvider = Objects.requireNonNull(connectorServicesProvider, "connectorServicesProvider is null");
        this.serviceGetter = Objects.requireNonNull(serviceGetter, "serviceGetter is null");
    }

    @Override
    public T getService(CatalogHandle catalogHandle) {
        ConnectorServices connectorServices = this.connectorServicesProvider.getConnectorServices(catalogHandle);
        T result = this.serviceGetter.apply(connectorServices);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"Catalog '%s' does not have a %s", (Object)catalogHandle, (Object)this.name);
        return result;
    }
}

