/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.LegacyConfig;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.util.List;

public class FileCatalogStoreConfig {
    private File catalogConfigurationDir = new File("etc/catalog/");
    private List<String> disabledCatalogs = ImmutableList.of();
    private boolean readOnly;

    @NotNull
    public File getCatalogConfigurationDir() {
        return this.catalogConfigurationDir;
    }

    @LegacyConfig(value={"plugin.config-dir"})
    @Config(value="catalog.config-dir")
    public FileCatalogStoreConfig setCatalogConfigurationDir(File dir) {
        this.catalogConfigurationDir = dir;
        return this;
    }

    public List<String> getDisabledCatalogs() {
        return this.disabledCatalogs;
    }

    @Config(value="catalog.disabled-catalogs")
    public FileCatalogStoreConfig setDisabledCatalogs(List<String> catalogs) {
        this.disabledCatalogs = ImmutableList.copyOf(catalogs);
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Config(value="catalog.read-only")
    public FileCatalogStoreConfig setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }
}

