/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.FullConnectorSession;
import io.trino.connector.system.SystemColumnHandle;
import io.trino.connector.system.SystemSplit;
import io.trino.connector.system.SystemTableHandle;
import io.trino.connector.system.SystemTablesProvider;
import io.trino.connector.system.SystemTransactionHandle;
import io.trino.plugin.base.MappedPageSource;
import io.trino.plugin.base.MappedRecordSet;
import io.trino.security.AccessControl;
import io.trino.security.InjectedConnectorAccessControl;
import io.trino.security.SecurityContext;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordPageSource;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SystemPageSourceProvider
implements ConnectorPageSourceProvider {
    private final SystemTablesProvider tables;
    private final AccessControl accessControl;
    private final String catalogName;

    public SystemPageSourceProvider(SystemTablesProvider tables, AccessControl accessControl, String catalogName) {
        this.tables = Objects.requireNonNull(tables, "tables is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        Objects.requireNonNull(columns, "columns is null");
        SystemTransactionHandle systemTransaction = (SystemTransactionHandle)transaction;
        SystemSplit systemSplit = (SystemSplit)split;
        SchemaTableName tableName = ((SystemTableHandle)table).schemaTableName();
        SystemTable systemTable = this.tables.getSystemTable(session, tableName).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Table '%s' not found", tableName)));
        List tableColumns = systemTable.getTableMetadata().getColumns();
        HashMap<String, Integer> columnsByName = new HashMap<String, Integer>();
        for (int i = 0; i < tableColumns.size(); ++i) {
            ColumnMetadata column = (ColumnMetadata)tableColumns.get(i);
            if (columnsByName.put(column.getName(), i) == null) continue;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Duplicate column name: " + column.getName());
        }
        ImmutableList.Builder userToSystemFieldIndex = ImmutableList.builder();
        ImmutableSet.Builder requiredColumns = ImmutableSet.builder();
        for (ColumnHandle column : columns) {
            String columnName = ((SystemColumnHandle)column).columnName();
            Integer index = (Integer)columnsByName.get(columnName);
            if (index == null) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Column does not exist: %s.%s", tableName, columnName));
            }
            userToSystemFieldIndex.add((Object)index);
            requiredColumns.add((Object)index);
        }
        TupleDomain<ColumnHandle> constraint = systemSplit.getConstraint();
        if (constraint.isNone()) {
            return new EmptyPageSource();
        }
        TupleDomain newConstraint = systemSplit.getConstraint().transformKeys(columnHandle -> (Integer)columnsByName.get(((SystemColumnHandle)columnHandle).columnName()));
        InjectedConnectorAccessControl accessControl1 = new InjectedConnectorAccessControl(this.accessControl, new SecurityContext(systemTransaction.getTransactionId(), ((FullConnectorSession)session).getSession().getIdentity(), QueryId.valueOf((String)session.getQueryId()), session.getStart()), this.catalogName);
        try {
            if (systemTable.getDistribution().equals((Object)SystemTable.Distribution.ALL_NODES)) {
                return new MappedPageSource(systemTable.pageSource(systemTransaction.getConnectorTransactionHandle(), session, newConstraint), (List)userToSystemFieldIndex.build());
            }
            return new MappedPageSource(systemTable.pageSource(systemTransaction.getConnectorTransactionHandle(), session, newConstraint, (ConnectorAccessControl)accessControl1), (List)userToSystemFieldIndex.build());
        }
        catch (UnsupportedOperationException e) {
            return new RecordPageSource((RecordSet)new MappedRecordSet(SystemPageSourceProvider.toRecordSet(systemTransaction.getConnectorTransactionHandle(), systemTable, session, (TupleDomain<Integer>)newConstraint, (Set<Integer>)requiredColumns.build(), systemSplit, accessControl1), (List)userToSystemFieldIndex.build()));
        }
    }

    private static RecordSet toRecordSet(final ConnectorTransactionHandle sourceTransaction, final SystemTable table, final ConnectorSession session, final TupleDomain<Integer> constraint, final Set<Integer> requiredColumns, final ConnectorSplit split, final ConnectorAccessControl accessControl1) {
        return new RecordSet(){
            private final List<Type> types;
            {
                this.types = (List)table.getTableMetadata().getColumns().stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
            }

            public List<Type> getColumnTypes() {
                return this.types;
            }

            public RecordCursor cursor() {
                if (table.getDistribution().equals((Object)SystemTable.Distribution.ALL_NODES)) {
                    return table.cursor(sourceTransaction, session, constraint, requiredColumns, split);
                }
                return table.cursor(sourceTransaction, session, constraint, requiredColumns, split, accessControl1);
            }
        };
    }
}

