/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.cost.PlanCostEstimate;
import java.util.Objects;
import java.util.stream.Stream;

public class LocalCostEstimate {
    private final double cpuCost;
    private final double maxMemory;
    private final double networkCost;

    public static LocalCostEstimate unknown() {
        return LocalCostEstimate.of(Double.NaN, Double.NaN, Double.NaN);
    }

    public static LocalCostEstimate zero() {
        return LocalCostEstimate.of(0.0, 0.0, 0.0);
    }

    public static LocalCostEstimate ofCpu(double cpuCost) {
        return LocalCostEstimate.of(cpuCost, 0.0, 0.0);
    }

    public static LocalCostEstimate ofNetwork(double networkCost) {
        return LocalCostEstimate.of(0.0, 0.0, networkCost);
    }

    public static LocalCostEstimate of(double cpuCost, double maxMemory, double networkCost) {
        return new LocalCostEstimate(cpuCost, maxMemory, networkCost);
    }

    @JsonCreator
    public LocalCostEstimate(@JsonProperty(value="cpuCost") double cpuCost, @JsonProperty(value="maxMemory") double maxMemory, @JsonProperty(value="networkCost") double networkCost) {
        Preconditions.checkArgument((Double.isNaN(cpuCost) || cpuCost >= 0.0 ? 1 : 0) != 0, (String)"cpuCost cannot be negative: %s", (Object)cpuCost);
        Preconditions.checkArgument((Double.isNaN(maxMemory) || maxMemory >= 0.0 ? 1 : 0) != 0, (String)"maxMemory cannot be negative: %s", (Object)maxMemory);
        Preconditions.checkArgument((Double.isNaN(networkCost) || networkCost >= 0.0 ? 1 : 0) != 0, (String)"networkCost cannot be negative: %s", (Object)networkCost);
        this.cpuCost = cpuCost;
        this.maxMemory = maxMemory;
        this.networkCost = networkCost;
    }

    @JsonProperty
    public double getCpuCost() {
        return this.cpuCost;
    }

    @JsonProperty
    public double getMaxMemory() {
        return this.maxMemory;
    }

    @JsonProperty
    public double getNetworkCost() {
        return this.networkCost;
    }

    @Deprecated
    public PlanCostEstimate toPlanCost() {
        return new PlanCostEstimate(this.cpuCost, this.maxMemory, this.maxMemory, this.networkCost, this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cpuCost", this.cpuCost).add("maxMemory", this.maxMemory).add("networkCost", this.networkCost).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalCostEstimate that = (LocalCostEstimate)o;
        return Double.compare(that.cpuCost, this.cpuCost) == 0 && Double.compare(that.maxMemory, this.maxMemory) == 0 && Double.compare(that.networkCost, this.networkCost) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.cpuCost, this.maxMemory, this.networkCost);
    }

    public static LocalCostEstimate addPartialComponents(LocalCostEstimate one, LocalCostEstimate two, LocalCostEstimate ... more) {
        return Stream.concat(Stream.of(one, two), Stream.of(more)).reduce(LocalCostEstimate.zero(), (a, b) -> new LocalCostEstimate(a.cpuCost + b.cpuCost, a.maxMemory + b.maxMemory, a.networkCost + b.networkCost));
    }
}

