/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.operator.RetryPolicy;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntSupplier;

public class TaskCountEstimator {
    private final IntSupplier numberOfNodes;

    @Inject
    public TaskCountEstimator(NodeSchedulerConfig nodeSchedulerConfig, InternalNodeManager nodeManager) {
        boolean schedulerIncludeCoordinator = nodeSchedulerConfig.isIncludeCoordinator();
        Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.numberOfNodes = () -> {
            Set<InternalNode> activeNodes = nodeManager.getAllNodes().getActiveNodes();
            int count = schedulerIncludeCoordinator ? activeNodes.size() : Math.toIntExact(activeNodes.stream().filter(node -> !node.isCoordinator()).count());
            return Math.max(count, 1);
        };
    }

    public TaskCountEstimator(IntSupplier numberOfNodes) {
        this.numberOfNodes = Objects.requireNonNull(numberOfNodes, "numberOfNodes is null");
    }

    public int estimateSourceDistributedTaskCount(Session session) {
        Integer costEstimationWorkerCount = SystemSessionProperties.getCostEstimationWorkerCount(session);
        if (costEstimationWorkerCount != null) {
            return costEstimationWorkerCount;
        }
        int count = this.numberOfNodes.getAsInt();
        Preconditions.checkState((count > 0 ? 1 : 0) != 0, (String)"%s should return positive number of nodes: %s", (Object)this.numberOfNodes, (int)count);
        return count;
    }

    public int estimateHashedTaskCount(Session session) {
        int partitionCount = SystemSessionProperties.getRetryPolicy(session) == RetryPolicy.TASK ? SystemSessionProperties.getFaultTolerantExecutionMaxPartitionCount(session) : SystemSessionProperties.getMaxHashPartitionCount(session);
        return Math.min(this.estimateSourceDistributedTaskCount(session), partitionCount);
    }
}

