/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.cost.ComposableStatsCalculator;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsCalculator;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.matching.Pattern;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlRow;
import io.trino.spi.statistics.StatsUtil;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Row;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.type.UnknownType;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;

public class ValuesStatsRule
implements ComposableStatsCalculator.Rule<ValuesNode> {
    private static final Pattern<ValuesNode> PATTERN = Patterns.values();

    @Override
    public Pattern<ValuesNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Optional<PlanNodeStatsEstimate> calculate(ValuesNode node, StatsCalculator.Context context) {
        PlanNodeStatsEstimate.Builder statsBuilder = PlanNodeStatsEstimate.builder();
        statsBuilder.setOutputRowCount(node.getRowCount());
        try {
            for (int symbolId = 0; symbolId < node.getOutputSymbols().size(); ++symbolId) {
                Symbol symbol = node.getOutputSymbols().get(symbolId);
                List<Object> symbolValues = this.getSymbolValues(node, symbolId, (Type)RowType.anonymous((List)((List)node.getOutputSymbols().stream().map(Symbol::type).collect(ImmutableList.toImmutableList()))));
                statsBuilder.addSymbolStatistics(symbol, this.buildSymbolStatistics(symbolValues, symbol.type()));
            }
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
        return Optional.of(statsBuilder.build());
    }

    private List<Object> getSymbolValues(ValuesNode valuesNode, int symbolId, Type rowType) {
        Type symbolType = (Type)rowType.getTypeParameters().get(symbolId);
        if (UnknownType.UNKNOWN.equals(symbolType)) {
            return IntStream.range(0, valuesNode.getRowCount()).mapToObj(rowId -> null).collect(Collectors.toList());
        }
        Preconditions.checkState((boolean)valuesNode.getRows().isPresent(), (Object)"rows is empty");
        return valuesNode.getRows().get().stream().map(row -> {
            Expression expression = row;
            Objects.requireNonNull(expression);
            Expression selector1$temp = expression;
            int index$2 = 0;
            block6: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Row.class, Constant.class}, (Expression)selector1$temp, index$2)) {
                    case 0: {
                        Row value = (Row)selector1$temp;
                        Object object = ((Constant)value.items().get(symbolId)).value();
                        return object;
                    }
                    case 1: {
                        Object patt4$temp;
                        Object object;
                        Constant $b$0 = (Constant)selector1$temp;
                        try {
                            Type patt3$temp;
                            Type type = patt3$temp = $b$0.type();
                            patt4$temp = $b$0.value();
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                        if (patt4$temp instanceof SqlRow) {
                            SqlRow value = (SqlRow)patt4$temp;
                            object = TypeUtils.readNativeValue((Type)symbolType, (Block)value.getRawFieldBlock(symbolId), (int)value.getRawIndex());
                            return object;
                        }
                        index$2 = 2;
                        continue block6;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Expected Row or Constant: " + String.valueOf(row));
        }).collect(Collectors.toList());
    }

    private SymbolStatsEstimate buildSymbolStatistics(List<Object> values, Type type) {
        List nonNullValues = (List)values.stream().filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        if (nonNullValues.isEmpty()) {
            return SymbolStatsEstimate.zero();
        }
        double[] valuesAsDoubles = nonNullValues.stream().map(value -> StatsUtil.toStatsRepresentation((Type)type, (Object)value)).filter(OptionalDouble::isPresent).mapToDouble(OptionalDouble::getAsDouble).toArray();
        double lowValue = DoubleStream.of(valuesAsDoubles).min().orElse(Double.NEGATIVE_INFINITY);
        double highValue = DoubleStream.of(valuesAsDoubles).max().orElse(Double.POSITIVE_INFINITY);
        double valuesCount = values.size();
        double nonNullValuesCount = nonNullValues.size();
        long distinctValuesCount = nonNullValues.stream().distinct().count();
        return SymbolStatsEstimate.builder().setNullsFraction((valuesCount - nonNullValuesCount) / valuesCount).setLowValue(lowValue).setHighValue(highValue).setDistinctValuesCount(distinctValuesCount).build();
    }
}

