/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.SqlFormatterUtil;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.Deallocate;
import io.trino.sql.tree.Execute;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Prepare;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class PrepareTask
implements DataDefinitionTask<Prepare> {
    private final SqlParser sqlParser;

    @Inject
    public PrepareTask(SqlParser sqlParser) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    @Override
    public String getName() {
        return "PREPARE";
    }

    @Override
    public ListenableFuture<Void> execute(Prepare prepare, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Statement statement = prepare.getStatement();
        if (statement instanceof Prepare || statement instanceof Execute || statement instanceof Deallocate) {
            String type = statement.getClass().getSimpleName().toUpperCase(Locale.ENGLISH);
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid statement type for prepared statement: " + type);
        }
        String sql = SqlFormatterUtil.getFormattedSql(statement, this.sqlParser);
        stateMachine.addPreparedStatement(prepare.getName().getValue(), sql);
        return Futures.immediateVoidFuture();
    }
}

