/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Rollback;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Objects;

public class RollbackTask
implements DataDefinitionTask<Rollback> {
    private final TransactionManager transactionManager;

    @Inject
    public RollbackTask(TransactionManager transactionManager) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
    }

    @Override
    public String getName() {
        return "ROLLBACK";
    }

    @Override
    public ListenableFuture<Void> execute(Rollback statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        TransactionId transactionId = session.getTransactionId().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_IN_TRANSACTION, "No transaction in progress"));
        stateMachine.clearTransactionId();
        this.transactionManager.asyncAbort(transactionId);
        return Futures.immediateVoidFuture();
    }
}

