/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.annotations.VisibleForTesting;
import io.airlift.compress.v3.Compressor;
import io.airlift.compress.v3.Decompressor;
import io.airlift.compress.v3.lz4.Lz4Compressor;
import io.airlift.compress.v3.lz4.Lz4Decompressor;
import io.airlift.compress.v3.zstd.ZstdCompressor;
import io.airlift.compress.v3.zstd.ZstdDecompressor;
import io.airlift.slice.SizeOf;
import io.trino.execution.buffer.CompressingDecryptingPageDeserializer;
import io.trino.execution.buffer.CompressingEncryptingPageSerializer;
import io.trino.execution.buffer.CompressionCodec;
import io.trino.execution.buffer.PageDeserializer;
import io.trino.execution.buffer.PageSerializer;
import io.trino.spi.block.BlockEncodingSerde;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.crypto.SecretKey;

public class PagesSerdeFactory {
    private static final int SERIALIZED_PAGE_DEFAULT_BLOCK_SIZE_IN_BYTES = 65536;
    private final BlockEncodingSerde blockEncodingSerde;
    private final CompressionCodec compressionCodec;
    private final int blockSizeInBytes;

    PagesSerdeFactory(BlockEncodingSerde blockEncodingSerde, CompressionCodec compressionCodec) {
        this(blockEncodingSerde, compressionCodec, 65536);
    }

    @VisibleForTesting
    PagesSerdeFactory(BlockEncodingSerde blockEncodingSerde, CompressionCodec compressionCodec, int blockSizeInBytes) {
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
        this.blockSizeInBytes = blockSizeInBytes;
    }

    public PageSerializer createSerializer(Optional<SecretKey> encryptionKey) {
        return new CompressingEncryptingPageSerializer(this.blockEncodingSerde, PagesSerdeFactory.createCompressor(this.compressionCodec), encryptionKey, this.blockSizeInBytes, PagesSerdeFactory.maxCompressedSize(this.blockSizeInBytes, this.compressionCodec));
    }

    public PageDeserializer createDeserializer(Optional<SecretKey> encryptionKey) {
        return new CompressingDecryptingPageDeserializer(this.blockEncodingSerde, PagesSerdeFactory.createDecompressor(this.compressionCodec), PagesSerdeFactory.decompressorRetainedSize(this.compressionCodec), encryptionKey, this.blockSizeInBytes, PagesSerdeFactory.maxCompressedSize(this.blockSizeInBytes, this.compressionCodec));
    }

    public static Optional<Compressor> createCompressor(CompressionCodec compressionCodec) {
        return switch (compressionCodec) {
            default -> throw new MatchException(null, null);
            case CompressionCodec.NONE -> Optional.empty();
            case CompressionCodec.LZ4 -> Optional.of(Lz4Compressor.create());
            case CompressionCodec.ZSTD -> Optional.of(ZstdCompressor.create());
        };
    }

    public static Optional<Decompressor> createDecompressor(CompressionCodec compressionCodec) {
        return switch (compressionCodec) {
            default -> throw new MatchException(null, null);
            case CompressionCodec.NONE -> Optional.empty();
            case CompressionCodec.LZ4 -> Optional.of(Lz4Decompressor.create());
            case CompressionCodec.ZSTD -> Optional.of(ZstdDecompressor.create());
        };
    }

    private static OptionalInt maxCompressedSize(int uncompressedSize, CompressionCodec compressionCodec) {
        return switch (compressionCodec) {
            default -> throw new MatchException(null, null);
            case CompressionCodec.NONE -> OptionalInt.of(uncompressedSize);
            case CompressionCodec.LZ4 -> CompressionCodec.LZ4.maxCompressedLength(uncompressedSize);
            case CompressionCodec.ZSTD -> CompressionCodec.ZSTD.maxCompressedLength(uncompressedSize);
        };
    }

    private static int decompressorRetainedSize(CompressionCodec compressionCodec) {
        return switch (compressionCodec) {
            default -> throw new MatchException(null, null);
            case CompressionCodec.NONE -> 0;
            case CompressionCodec.LZ4 -> SizeOf.instanceSize(Lz4Decompressor.class);
            case CompressionCodec.ZSTD -> SizeOf.instanceSize(ZstdDecompressor.class);
        };
    }
}

