/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.executor.dedicated;

import com.google.common.base.Preconditions;

class ConcurrencyController {
    private static final double TARGET_UTILIZATION = 0.5;
    private int targetConcurrency;

    public ConcurrencyController(int initialConcurrency) {
        Preconditions.checkArgument((initialConcurrency > 0 ? 1 : 0) != 0, (Object)"initial concurrency must be positive");
        this.targetConcurrency = initialConcurrency;
    }

    public void update(double utilization, int currentConcurrency) {
        if (utilization > 0.5 && this.targetConcurrency > 1) {
            --this.targetConcurrency;
        } else if (utilization < 0.5 && currentConcurrency >= this.targetConcurrency) {
            ++this.targetConcurrency;
        }
    }

    public int targetConcurrency() {
        return this.targetConcurrency;
    }
}

