/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.executor.scheduler;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.trino.execution.executor.scheduler.SchedulingQueue;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@ThreadSafe
final class BlockingSchedulingQueue<G, T> {
    private final Lock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    @GuardedBy(value="lock")
    private final SchedulingQueue<G, T> queue = new SchedulingQueue();

    BlockingSchedulingQueue() {
    }

    public void startGroup(G group) {
        this.lock.lock();
        try {
            this.queue.startGroup(group);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<T> finishGroup(G group) {
        this.lock.lock();
        try {
            Set<T> set = this.queue.finishGroup(group);
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<T> getTasks(G group) {
        this.lock.lock();
        try {
            if (!this.queue.containsGroup(group)) {
                ImmutableSet immutableSet = ImmutableSet.of();
                return immutableSet;
            }
            Set<T> set = this.queue.getTasks(group);
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<T> finishAll() {
        this.lock.lock();
        try {
            Set<T> set = this.queue.finishAll();
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueue(G group, T task, long deltaWeight) {
        this.lock.lock();
        try {
            if (!this.queue.containsGroup(group)) {
                boolean bl = false;
                return bl;
            }
            this.queue.enqueue(group, task, deltaWeight);
            this.notEmpty.signal();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean block(G group, T task, long deltaWeight) {
        this.lock.lock();
        try {
            if (!this.queue.containsGroup(group)) {
                boolean bl = false;
                return bl;
            }
            this.queue.block(group, task, deltaWeight);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T dequeue(long expectedWeight) throws InterruptedException {
        this.lock.lock();
        try {
            T result;
            do {
                if ((result = this.queue.dequeue(expectedWeight)) != null) continue;
                this.notEmpty.await();
            } while (result == null);
            T t = result;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finish(G group, T task) {
        this.lock.lock();
        try {
            if (!this.queue.containsGroup(group)) {
                boolean bl = false;
                return bl;
            }
            this.queue.finish(group, task);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        this.lock.lock();
        try {
            String string = this.queue.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getRunnableCount() {
        this.lock.lock();
        try {
            int n = this.queue.getRunnableCount();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

