/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.executor.scheduler;

import com.google.errorprone.annotations.ThreadSafe;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@ThreadSafe
final class Gate {
    private final Lock lock = new ReentrantLock();
    private final Condition opened = this.lock.newCondition();
    private boolean open;

    public Gate(boolean opened) {
        this.open = opened;
    }

    public void close() {
        this.lock.lock();
        try {
            this.open = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void open() {
        this.lock.lock();
        try {
            this.open = true;
            this.opened.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void awaitOpen() throws InterruptedException {
        this.lock.lock();
        try {
            while (!this.open) {
                this.opened.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

