/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.executor.scheduler;

import com.google.common.base.Preconditions;
import io.trino.annotation.NotThreadSafe;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

@NotThreadSafe
final class PriorityQueue<T> {
    private final Map<T, Priority> priorities = new HashMap<T, Priority>();
    private final TreeSet<T> queue = new TreeSet((a, b) -> {
        Priority first = this.priorities.get(a);
        Priority second = this.priorities.get(b);
        int result = Long.compare(first.priority(), second.priority());
        if (result == 0) {
            result = Long.compare(first.sequence(), second.sequence());
        }
        return result;
    });
    private long sequence;

    public void add(T value, long priority) {
        Preconditions.checkArgument((!this.priorities.containsKey(value) ? 1 : 0) != 0, (String)"Value already in queue: %s", value);
        this.priorities.put(value, new Priority(priority, this.nextSequence()));
        this.queue.add(value);
    }

    public void addOrReplace(T value, long priority) {
        if (this.priorities.containsKey(value)) {
            this.queue.remove(value);
            this.priorities.put(value, new Priority(priority, this.nextSequence()));
            this.queue.add(value);
        } else {
            this.add(value, priority);
        }
    }

    public T takeOrThrow() {
        T result = this.poll();
        Preconditions.checkState((result != null ? 1 : 0) != 0, (Object)"Queue is empty");
        return result;
    }

    public T poll() {
        T result = this.queue.pollFirst();
        if (result != null) {
            this.priorities.remove(result);
        }
        return result;
    }

    public void remove(T value) {
        Preconditions.checkArgument((boolean)this.priorities.containsKey(value), (String)"Value not in queue: %s", value);
        this.queue.remove(value);
        this.priorities.remove(value);
    }

    public void removeIfPresent(T value) {
        if (this.priorities.containsKey(value)) {
            this.queue.remove(value);
            this.priorities.remove(value);
        }
    }

    public boolean contains(T value) {
        return this.priorities.containsKey(value);
    }

    public boolean isEmpty() {
        return this.priorities.isEmpty();
    }

    public Set<T> values() {
        return this.priorities.keySet();
    }

    public long nextPriority() {
        Preconditions.checkState((!this.queue.isEmpty() ? 1 : 0) != 0, (Object)"Queue is empty");
        return this.priorities.get(this.queue.first()).priority();
    }

    public T peek() {
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.queue.first();
    }

    public int size() {
        return this.queue.size();
    }

    public String toString() {
        return this.queue.toString();
    }

    private long nextSequence() {
        return this.sequence++;
    }

    private record Priority(long priority, long sequence) {
    }
}

