/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json;

import com.google.common.base.Preconditions;
import io.trino.json.PathEvaluationException;
import io.trino.json.ir.TypedValue;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import java.util.Objects;

public class PathEvaluationContext {
    private final TypedValue last;
    private final Object currentItem;

    public PathEvaluationContext() {
        this(new TypedValue((Type)IntegerType.INTEGER, -1L), null);
    }

    private PathEvaluationContext(TypedValue last, Object currentItem) {
        this.last = last;
        this.currentItem = currentItem;
    }

    public PathEvaluationContext withLast(long last) {
        Preconditions.checkArgument((last >= 0L ? 1 : 0) != 0, (Object)"last array index must not be negative");
        return new PathEvaluationContext(new TypedValue((Type)IntegerType.INTEGER, last), this.currentItem);
    }

    public PathEvaluationContext withCurrentItem(Object currentItem) {
        Objects.requireNonNull(currentItem, "currentItem is null");
        return new PathEvaluationContext(this.last, currentItem);
    }

    public TypedValue getLast() {
        if (this.last.getLongValue() < 0L) {
            throw new PathEvaluationException("accessing the last array index with no enclosing array");
        }
        return this.last;
    }

    public Object getCurrentItem() {
        if (this.currentItem == null) {
            throw new PathEvaluationException("accessing current filter item with no enclosing filter");
        }
        return this.currentItem;
    }
}

