/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json;

import com.google.errorprone.annotations.FormatMethod;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;

public class PathEvaluationException
extends TrinoException {
    public PathEvaluationException(String message) {
        super((ErrorCodeSupplier)StandardErrorCode.PATH_EVALUATION_ERROR, "path evaluation failed: " + message);
    }

    public PathEvaluationException(Throwable cause) {
        super((ErrorCodeSupplier)StandardErrorCode.PATH_EVALUATION_ERROR, "path evaluation failed: ", cause);
    }

    @FormatMethod
    public static TrinoException structuralError(String format, Object ... arguments) {
        return new PathEvaluationException("structural error: " + String.format(format, arguments));
    }

    public static TrinoException itemTypeError(String expected, String actual) {
        return new PathEvaluationException(String.format("invalid item type. Expected: %s, actual: %s", expected, actual));
    }
}

