/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import io.trino.json.ir.IrJsonPathVisitor;
import io.trino.json.ir.IrPathNode;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public record IrConstantJsonSequence(List<JsonNode> sequence, Optional<Type> type) implements IrPathNode
{
    public static final IrConstantJsonSequence EMPTY_SEQUENCE = new IrConstantJsonSequence((List<JsonNode>)ImmutableList.of(), Optional.empty());

    public IrConstantJsonSequence(List<JsonNode> sequence, Optional<Type> type) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.sequence = ImmutableList.copyOf(sequence);
    }

    public static IrConstantJsonSequence singletonSequence(JsonNode jsonNode, Optional<Type> type) {
        return new IrConstantJsonSequence((List<JsonNode>)ImmutableList.of((Object)jsonNode), type);
    }

    @Override
    public <R, C> R accept(IrJsonPathVisitor<R, C> visitor, C context) {
        return visitor.visitIrConstantJsonSequence(this, context);
    }
}

