/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.trino.execution.TaskId;
import io.trino.spi.QueryId;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class KillTarget {
    private final Optional<QueryId> query;
    private final Set<TaskId> tasks;

    public static KillTarget wholeQuery(QueryId queryId) {
        return new KillTarget(Optional.of(queryId), (Set<TaskId>)ImmutableSet.of());
    }

    public static KillTarget selectedTasks(Set<TaskId> tasks) {
        return new KillTarget(Optional.empty(), tasks);
    }

    private KillTarget(Optional<QueryId> query, Set<TaskId> tasks) {
        Objects.requireNonNull(query, "query is null");
        Objects.requireNonNull(tasks, "tasks is null");
        if (query.isPresent() && !tasks.isEmpty() || query.isEmpty() && tasks.isEmpty()) {
            throw new IllegalArgumentException("either query or tasks must be set");
        }
        this.query = query;
        this.tasks = ImmutableSet.copyOf(tasks);
    }

    public boolean isWholeQuery() {
        return this.query.isPresent();
    }

    public QueryId getQuery() {
        return this.query.orElseThrow(() -> new IllegalStateException("query not set in KillTarget: " + String.valueOf(this)));
    }

    public Set<TaskId> getTasks() {
        Preconditions.checkState((!this.tasks.isEmpty() ? 1 : 0) != 0, (Object)("tasks not set in KillTarget: " + String.valueOf(this)));
        return this.tasks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KillTarget that = (KillTarget)o;
        return Objects.equals(this.query, that.query) && Objects.equals(this.tasks, that.tasks);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.tasks);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("query", this.query).add("tasks", this.tasks).toString();
    }
}

