/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import com.google.errorprone.annotations.ThreadSafe;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@ThreadSafe
public class CatalogProcedures {
    private final Map<SchemaTableName, Procedure> procedures;

    public CatalogProcedures(Collection<Procedure> procedures) {
        Objects.requireNonNull(procedures, "procedures is null");
        procedures.forEach(CatalogProcedures::validateProcedure);
        this.procedures = Maps.uniqueIndex(procedures, procedure -> new SchemaTableName(procedure.getSchema(), procedure.getName()));
    }

    public Procedure getProcedure(SchemaTableName name) {
        Procedure procedure = this.procedures.get(name);
        if (procedure == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.PROCEDURE_NOT_FOUND, "Procedure not registered: " + String.valueOf(name));
        }
        return procedure;
    }

    private static void validateProcedure(Procedure procedure) {
        List parameters = procedure.getMethodHandle().type().parameterList().stream().filter(type -> !ConnectorSession.class.equals(type)).filter(type -> !ConnectorAccessControl.class.equals(type)).collect(Collectors.toList());
        for (int i = 0; i < procedure.getArguments().size(); ++i) {
            Procedure.Argument argument = (Procedure.Argument)procedure.getArguments().get(i);
            Type type2 = argument.getType();
            Class argumentType = Primitives.unwrap((Class)((Class)parameters.get(i)));
            Class<?> expectedType = CatalogProcedures.getObjectType(type2);
            Preconditions.checkArgument((boolean)expectedType.equals(argumentType), (String)"Argument '%s' has invalid type %s (expected %s)", (Object)argument.getName(), (Object)argumentType.getName(), (Object)expectedType.getName());
        }
    }

    private static Class<?> getObjectType(Type type) {
        if (type.equals((Object)BooleanType.BOOLEAN)) {
            return Boolean.TYPE;
        }
        if (type.equals((Object)BigintType.BIGINT)) {
            return Long.TYPE;
        }
        if (type.equals((Object)DoubleType.DOUBLE)) {
            return Double.TYPE;
        }
        if (type.equals((Object)VarcharType.VARCHAR)) {
            return String.class;
        }
        if (type instanceof ArrayType) {
            CatalogProcedures.getObjectType((Type)type.getTypeParameters().get(0));
            return List.class;
        }
        if (type instanceof MapType) {
            CatalogProcedures.getObjectType((Type)type.getTypeParameters().get(0));
            CatalogProcedures.getObjectType((Type)type.getTypeParameters().get(1));
            return Map.class;
        }
        throw new IllegalArgumentException("Unsupported argument type: " + type.getDisplayName());
    }
}

