/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.inject.Inject;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.metadata.BlockEncodingManager;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.assertj.core.util.VisibleForTesting;

public final class InternalBlockEncodingSerde
implements BlockEncodingSerde {
    private final Function<String, BlockEncoding> nameToEncoding;
    private final Function<Class<? extends Block>, BlockEncoding> blockToEncoding;
    private final Function<TypeId, Type> types;

    @Inject
    public InternalBlockEncodingSerde(BlockEncodingManager blockEncodingManager, TypeManager typeManager) {
        this(blockEncodingManager::getBlockEncodingByName, blockEncodingManager::getBlockEncodingByBlockClass, arg_0 -> ((TypeManager)typeManager).getType(arg_0));
    }

    @VisibleForTesting
    InternalBlockEncodingSerde(Function<String, BlockEncoding> nameToEncoding, Function<Class<? extends Block>, BlockEncoding> blockToEncoding, Function<TypeId, Type> types) {
        this.nameToEncoding = Objects.requireNonNull(nameToEncoding, "nameToEncoding is null");
        this.blockToEncoding = Objects.requireNonNull(blockToEncoding, "blockToEncoding is null");
        this.types = Objects.requireNonNull(types, "types is null");
    }

    public Block readBlock(SliceInput input) {
        String encodingName = InternalBlockEncodingSerde.readLengthPrefixedString(input);
        BlockEncoding blockEncoding = this.nameToEncoding.apply(encodingName);
        return blockEncoding.readBlock((BlockEncodingSerde)this, input);
    }

    public void writeBlock(SliceOutput output, Block block) {
        BlockEncoding blockEncoding;
        Optional replacementBlock;
        while ((replacementBlock = (blockEncoding = this.blockToEncoding.apply(block.getClass())).replacementBlockForWrite(block)).isPresent()) {
            block = (Block)replacementBlock.get();
        }
        InternalBlockEncodingSerde.writeLengthPrefixedString(output, blockEncoding.getName());
        blockEncoding.writeBlock((BlockEncodingSerde)this, output, block);
    }

    public long estimatedWriteSize(Block block) {
        BlockEncoding blockEncoding;
        Optional replacementBlock;
        while ((replacementBlock = (blockEncoding = this.blockToEncoding.apply(block.getClass())).replacementBlockForWrite(block)).isPresent()) {
            block = (Block)replacementBlock.get();
        }
        return (long)(4 + blockEncoding.getName().length()) + block.getSizeInBytes();
    }

    public Type readType(SliceInput sliceInput) {
        Objects.requireNonNull(sliceInput, "sliceInput is null");
        String id = InternalBlockEncodingSerde.readLengthPrefixedString(sliceInput);
        Type type = this.types.apply(TypeId.of((String)id));
        if (type == null) {
            throw new IllegalArgumentException("Unknown type " + id);
        }
        return type;
    }

    public void writeType(SliceOutput sliceOutput, Type type) {
        Objects.requireNonNull(sliceOutput, "sliceOutput is null");
        Objects.requireNonNull(type, "type is null");
        InternalBlockEncodingSerde.writeLengthPrefixedString(sliceOutput, type.getTypeId().getId());
    }

    private static String readLengthPrefixedString(SliceInput input) {
        int length = input.readInt();
        byte[] bytes = new byte[length];
        input.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void writeLengthPrefixedString(SliceOutput output, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        output.writeInt(bytes.length);
        output.writeBytes(bytes);
    }
}

