/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import io.trino.spi.function.LanguageFunctionEngine;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class LanguageFunctionEngineManager {
    private final Map<String, LanguageFunctionEngine> languageFunctionEngines = new ConcurrentHashMap<String, LanguageFunctionEngine>();

    public Optional<LanguageFunctionEngine> getLanguageFunctionEngine(String language) {
        return Optional.ofNullable(this.languageFunctionEngines.get(language.toUpperCase(Locale.ENGLISH)));
    }

    public void addLanguageFunctionEngine(LanguageFunctionEngine engine) {
        if (this.languageFunctionEngines.putIfAbsent(engine.getLanguage().toUpperCase(Locale.ENGLISH), engine) != null) {
            throw new IllegalArgumentException("Language function engine for language %s is already registered".formatted(engine.getLanguage()));
        }
    }
}

