/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.ViewColumn;
import io.trino.metadata.ViewDefinition;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.security.Identity;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MaterializedViewDefinition
extends ViewDefinition {
    private final Optional<Duration> gracePeriod;
    private final Optional<CatalogSchemaTableName> storageTable;

    public MaterializedViewDefinition(String originalSql, Optional<String> catalog, Optional<String> schema, List<ViewColumn> columns, Optional<Duration> gracePeriod, Optional<String> comment, Identity owner, List<CatalogSchemaName> path, Optional<CatalogSchemaTableName> storageTable) {
        super(originalSql, catalog, schema, columns, comment, Optional.of(owner), path);
        this.gracePeriod = Objects.requireNonNull(gracePeriod, "gracePeriod is null");
        Preconditions.checkArgument((gracePeriod.isEmpty() || !gracePeriod.get().isNegative() ? 1 : 0) != 0, (String)"gracePeriod cannot be negative: %s", gracePeriod);
        this.storageTable = Objects.requireNonNull(storageTable, "storageTable is null");
    }

    public Optional<Duration> getGracePeriod() {
        return this.gracePeriod;
    }

    public Optional<CatalogSchemaTableName> getStorageTable() {
        return this.storageTable;
    }

    public ConnectorMaterializedViewDefinition toConnectorMaterializedViewDefinition() {
        return new ConnectorMaterializedViewDefinition(this.getOriginalSql(), this.storageTable, this.getCatalog(), this.getSchema(), (List)this.getColumns().stream().map(column -> new ConnectorMaterializedViewDefinition.Column(column.name(), column.type(), column.comment())).collect(ImmutableList.toImmutableList()), this.getGracePeriod(), this.getComment(), this.getRunAsIdentity().map(Identity::getUser), this.getPath());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("originalSql", (Object)this.getOriginalSql()).add("catalog", this.getCatalog().orElse(null)).add("schema", this.getSchema().orElse(null)).add("columns", this.getColumns()).add("gracePeriod", this.gracePeriod.orElse(null)).add("comment", this.getComment().orElse(null)).add("runAsIdentity", this.getRunAsIdentity()).add("path", this.getPath()).add("storageTable", this.storageTable.orElse(null)).toString();
    }
}

