/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import io.trino.Session;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Location;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.ConstantEvaluator;
import io.trino.sql.analyzer.ExpressionTreeUtils;
import io.trino.sql.planner.ParameterRewriter;
import io.trino.sql.tree.Array;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.StringLiteral;
import io.trino.util.MoreLists;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public final class PropertyUtil {
    private PropertyUtil() {
    }

    public static Map<String, Optional<Object>> evaluateProperties(Iterable<Property> setProperties, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters, boolean includeAllProperties, Map<String, PropertyMetadata<?>> metadata, ErrorCodeSupplier errorCode, String propertyTypeDescription) {
        LinkedHashMap<String, Optional<Object>> propertyValues = new LinkedHashMap<String, Optional<Object>>();
        for (Property property : setProperties) {
            Optional<Location> location = ExpressionTreeUtils.extractLocation((Node)property);
            String propertyName = property.getName().getValue().toLowerCase(Locale.ENGLISH);
            PropertyMetadata<?> propertyMetadata = metadata.get(propertyName);
            if (propertyMetadata == null) {
                String message = "%s '%s' does not exist".formatted(PropertyUtil.capitalize(propertyTypeDescription), propertyName);
                throw new TrinoException(errorCode, location, message, null);
            }
            Optional<Object> value = property.isSetToDefault() ? Optional.ofNullable(propertyMetadata.getDefaultValue()) : Optional.of(PropertyUtil.evaluateProperty(location, property.getNonDefaultValue(), propertyMetadata, session, plannerContext, accessControl, parameters, errorCode, propertyTypeDescription));
            propertyValues.put(propertyMetadata.getName(), value);
        }
        if (includeAllProperties) {
            for (PropertyMetadata propertyMetadata : metadata.values()) {
                if (propertyValues.containsKey(propertyMetadata.getName())) continue;
                propertyValues.put(propertyMetadata.getName(), Optional.ofNullable(propertyMetadata.getDefaultValue()));
            }
        }
        return ImmutableMap.copyOf(propertyValues);
    }

    private static Object evaluateProperty(Optional<Location> location, Expression expression, PropertyMetadata<?> property, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters, ErrorCodeSupplier errorCode, String propertyTypeDescription) {
        Object sqlObjectValue = PropertyUtil.evaluateProperty(location, property.getName(), property.getSqlType(), expression, session, plannerContext, accessControl, parameters, errorCode, propertyTypeDescription);
        try {
            return property.decode(sqlObjectValue);
        }
        catch (Exception e) {
            String message = "Unable to set %s '%s' to [%s]: %s".formatted(propertyTypeDescription, property.getName(), expression, e.getMessage());
            throw new TrinoException(errorCode, location, message, (Throwable)e);
        }
    }

    public static Object evaluateProperty(Optional<Location> location, String propertyName, Type propertyType, Expression expression, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters, ErrorCodeSupplier errorCode, String propertyTypeDescription) {
        Object sqlObjectValue;
        try {
            Expression rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(parameters), (Expression)expression);
            Object value = ConstantEvaluator.evaluateConstant(rewritten, propertyType, plannerContext, session, accessControl);
            ValueBlock block = TypeUtils.writeNativeValue((Type)propertyType, (Object)value);
            sqlObjectValue = propertyType.getObjectValue(session.toConnectorSession(), (Block)block, 0);
        }
        catch (TrinoException e) {
            String message = "Invalid value for %s '%s': Cannot convert [%s] to %s".formatted(propertyTypeDescription, propertyName, expression, propertyType);
            throw new TrinoException(errorCode, location, message, (Throwable)e);
        }
        if (sqlObjectValue == null) {
            String message = "Invalid null value for %s '%s' from [%s]".formatted(propertyTypeDescription, propertyName, expression);
            throw new TrinoException(errorCode, location, message, null);
        }
        return sqlObjectValue;
    }

    public static List<Property> toSqlProperties(Object description, ErrorCodeSupplier errorCode, Map<String, Object> properties, Iterable<PropertyMetadata<?>> metadata) {
        if (properties.isEmpty()) {
            return List.of();
        }
        ImmutableMap indexedMetadata = Maps.uniqueIndex(metadata, PropertyMetadata::getName);
        ImmutableSortedMap.Builder sqlProperties = ImmutableSortedMap.naturalOrder();
        properties.forEach((arg_0, arg_1) -> PropertyUtil.lambda$toSqlProperties$0(errorCode, description, (Map)indexedMetadata, sqlProperties, arg_0, arg_1));
        return (List)sqlProperties.build().entrySet().stream().map(entry -> new Property(new Identifier((String)entry.getKey()), (Expression)entry.getValue())).collect(ImmutableList.toImmutableList());
    }

    private static <T> Expression toExpression(ErrorCodeSupplier errorcode, PropertyMetadata<T> property, Object value) throws TrinoException {
        return PropertyUtil.toExpression(errorcode, property.encode(property.getJavaType().cast(value)));
    }

    private static Expression toExpression(ErrorCodeSupplier errorCode, Object value) throws TrinoException {
        StringLiteral stringLiteral;
        Object object = value;
        int n = 0;
        block8: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Boolean.class, Long.class, Integer.class, Double.class, List.class}, (Object)object, n)) {
                case 0: {
                    stringLiteral = new StringLiteral(value.toString());
                    break block8;
                }
                case 1: {
                    stringLiteral = new BooleanLiteral(value.toString());
                    break block8;
                }
                case 2: 
                case 3: {
                    if (!(object instanceof Long) && !(object instanceof Integer)) {
                        n = 4;
                        continue block8;
                    }
                    stringLiteral = new LongLiteral(value.toString());
                    break block8;
                }
                case 4: {
                    stringLiteral = new DoubleLiteral(value.toString());
                    break block8;
                }
                case 5: {
                    List list = (List)object;
                    stringLiteral = new Array(MoreLists.mappedCopy(list, item -> PropertyUtil.toExpression(errorCode, item)));
                    break block8;
                }
                case -1: {
                    throw new TrinoException(errorCode, "Property value is null");
                }
                default: {
                    throw new TrinoException(errorCode, "Failed to convert object of type %s to expression".formatted(value.getClass().getName()));
                }
            }
            break;
        }
        return stringLiteral;
    }

    private static String capitalize(String value) {
        return Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }

    private static /* synthetic */ void lambda$toSqlProperties$0(ErrorCodeSupplier errorCode, Object description, Map indexedMetadata, ImmutableSortedMap.Builder sqlProperties, String name, Object value) {
        if (value == null) {
            throw new TrinoException(errorCode, "Property %s for %s cannot have a null value".formatted(name, description));
        }
        PropertyMetadata property = (PropertyMetadata)indexedMetadata.get(name);
        if (property == null) {
            throw new TrinoException(errorCode, "No PropertyMetadata for property: " + name);
        }
        if (!Primitives.wrap((Class)property.getJavaType()).isInstance(value)) {
            throw new TrinoException(errorCode, "Property %s for %s should have value of type %s, not %s".formatted(name, description, property.getJavaType().getName(), value.getClass().getName()));
        }
        sqlProperties.put((Object)name, (Object)PropertyUtil.toExpression(errorCode, property, value));
    }
}

