/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Split {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(Split.class);
    private final CatalogHandle catalogHandle;
    private final ConnectorSplit connectorSplit;

    @JsonCreator
    public Split(@JsonProperty(value="catalogHandle") CatalogHandle catalogHandle, @JsonProperty(value="connectorSplit") ConnectorSplit connectorSplit) {
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        this.connectorSplit = Objects.requireNonNull(connectorSplit, "connectorSplit is null");
    }

    @JsonProperty
    public CatalogHandle getCatalogHandle() {
        return this.catalogHandle;
    }

    @JsonProperty
    public ConnectorSplit getConnectorSplit() {
        return this.connectorSplit;
    }

    @JsonIgnore
    public Map<String, String> getInfo() {
        return (Map)MoreObjects.firstNonNull((Object)this.connectorSplit.getSplitInfo(), (Object)ImmutableMap.of());
    }

    public List<HostAddress> getAddresses() {
        return this.connectorSplit.getAddresses();
    }

    public boolean isRemotelyAccessible() {
        return this.connectorSplit.isRemotelyAccessible();
    }

    public SplitWeight getSplitWeight() {
        return this.connectorSplit.getSplitWeight();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogHandle", (Object)this.catalogHandle).add("connectorSplit", (Object)this.connectorSplit).toString();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.catalogHandle.getRetainedSizeInBytes() + this.connectorSplit.getRetainedSizeInBytes();
    }
}

