/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.inject.Inject;
import io.trino.connector.CatalogServiceProvider;
import io.trino.metadata.CatalogTableFunctions;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.function.Signature;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.function.table.ScalarArgumentSpecification;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@ThreadSafe
public class TableFunctionRegistry {
    private final CatalogServiceProvider<CatalogTableFunctions> tableFunctionsProvider;

    @Inject
    public TableFunctionRegistry(CatalogServiceProvider<CatalogTableFunctions> tableFunctionsProvider) {
        this.tableFunctionsProvider = Objects.requireNonNull(tableFunctionsProvider, "tableFunctionsProvider is null");
    }

    public List<FunctionMetadata> listTableFunctions(CatalogHandle catalogHandle) {
        return (List)this.tableFunctionsProvider.getService(catalogHandle).listTableFunctions().values().stream().map(TableFunctionRegistry::toFunctionMetadata).collect(ImmutableList.toImmutableList());
    }

    public List<FunctionMetadata> listTableFunctions(CatalogHandle catalogHandle, String schemaName) {
        return (List)this.tableFunctionsProvider.getService(catalogHandle).listTableFunctions().values().stream().filter(function -> function.getSchema().equals(schemaName)).map(TableFunctionRegistry::toFunctionMetadata).collect(ImmutableList.toImmutableList());
    }

    public Optional<ConnectorTableFunction> resolve(CatalogHandle catalogHandle, SchemaFunctionName schemaFunctionName) {
        return this.tableFunctionsProvider.getService(catalogHandle).getTableFunction(schemaFunctionName);
    }

    private static FunctionMetadata toFunctionMetadata(ConnectorTableFunction tableFunction) {
        return FunctionMetadata.tableBuilder((String)tableFunction.getName()).signature(Signature.builder().argumentTypes(TableFunctionRegistry.toArgumentTypes(tableFunction)).returnType((Type)UnknownType.UNKNOWN).build()).noDescription().nondeterministic().build();
    }

    private static List<TypeSignature> toArgumentTypes(ConnectorTableFunction tableFunction) {
        return (List)tableFunction.getArguments().stream().map(function -> {
            if (function instanceof ScalarArgumentSpecification) {
                ScalarArgumentSpecification scalarArgument = (ScalarArgumentSpecification)function;
                return scalarArgument.getType().getTypeSignature();
            }
            return UnknownType.UNKNOWN.getTypeSignature();
        }).collect(ImmutableList.toImmutableList());
    }
}

