/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import io.trino.metadata.QualifiedObjectName;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Objects;

public record TableMetadata(CatalogName catalogName, ConnectorTableMetadata metadata) {
    public TableMetadata {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(metadata, "metadata is null");
    }

    public QualifiedObjectName qualifiedName() {
        return new QualifiedObjectName(this.catalogName.toString(), this.metadata.getTable().getSchemaName(), this.metadata.getTable().getTableName());
    }

    public SchemaTableName table() {
        return this.metadata.getTable();
    }

    public List<ColumnMetadata> columns() {
        return this.metadata.getColumns();
    }

    public ColumnMetadata column(String name) {
        return this.columns().stream().filter(columnMetadata -> columnMetadata.getName().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid column name: " + name));
    }
}

