/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.MoreCollectors;
import io.trino.metadata.QualifiedObjectName;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.connector.ConnectorTableSchema;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public record TableSchema(CatalogName catalogName, ConnectorTableSchema tableSchema) {
    public TableSchema {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(tableSchema, "metadata is null");
    }

    public QualifiedObjectName qualifiedName() {
        return new QualifiedObjectName(this.catalogName.toString(), this.tableSchema.getTable().getSchemaName(), this.tableSchema.getTable().getTableName());
    }

    public SchemaTableName table() {
        return this.tableSchema.getTable();
    }

    public List<ColumnSchema> columns() {
        return this.tableSchema.getColumns();
    }

    public ColumnSchema column(String name) {
        return (ColumnSchema)((Optional)this.tableSchema.getColumns().stream().filter(columnMetadata -> columnMetadata.getName().equals(name)).collect(MoreCollectors.toOptional())).orElseThrow(() -> new IllegalArgumentException("Invalid column name: " + name));
    }
}

