/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.inject.Inject;
import io.trino.execution.TaskId;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.LanguageFunctionDefinition;
import io.trino.metadata.LanguageFunctionEngineManager;
import io.trino.metadata.LanguageFunctionProvider;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.LanguageFunctionEngine;
import io.trino.spi.function.ScalarFunctionImplementation;
import io.trino.sql.routine.SqlRoutineCompiler;
import io.trino.sql.routine.ir.IrRoutine;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class WorkerLanguageFunctionProvider
implements LanguageFunctionProvider {
    private final LanguageFunctionEngineManager languageFunctionEngineManager;
    private final Map<TaskId, Map<FunctionId, LanguageFunctionProvider.LanguageFunctionData>> queryFunctions = new ConcurrentHashMap<TaskId, Map<FunctionId, LanguageFunctionProvider.LanguageFunctionData>>();

    @Inject
    public WorkerLanguageFunctionProvider(LanguageFunctionEngineManager languageFunctionEngineManager) {
        this.languageFunctionEngineManager = Objects.requireNonNull(languageFunctionEngineManager, "languageFunctionEngineManager is null");
    }

    @Override
    public void registerTask(TaskId taskId2, Map<FunctionId, LanguageFunctionProvider.LanguageFunctionData> functions) {
        this.queryFunctions.computeIfAbsent(taskId2, taskId -> functions);
    }

    @Override
    public void unregisterTask(TaskId taskId) {
        this.queryFunctions.remove(taskId);
    }

    @Override
    public ScalarFunctionImplementation specialize(FunctionId functionId, InvocationConvention invocationConvention, FunctionManager functionManager) {
        LanguageFunctionProvider.LanguageFunctionData data = this.queryFunctions.values().stream().map(queryFunctions -> (LanguageFunctionProvider.LanguageFunctionData)queryFunctions.get(functionId)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("Unknown function implementation: " + String.valueOf(functionId)));
        if (data.definition().isPresent()) {
            LanguageFunctionDefinition definition = data.definition().get();
            LanguageFunctionEngine engine = this.languageFunctionEngineManager.getLanguageFunctionEngine(definition.language()).orElseThrow(() -> new IllegalStateException("No language function engine for language: " + definition.language()));
            return engine.getScalarFunctionImplementation(definition.returnType(), definition.argumentTypes(), definition.definition(), definition.properties(), invocationConvention);
        }
        IrRoutine routine = data.irRoutine().orElseThrow();
        SpecializedSqlScalarFunction function = new SqlRoutineCompiler(functionManager).compile(routine);
        return function.getScalarFunctionImplementation(invocationConvention);
    }
}

