/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Verify;
import com.google.common.primitives.Ints;
import io.airlift.slice.SizeOf;
import io.trino.operator.VariableWidthData;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class AppendOnlyVariableWidthData {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(AppendOnlyVariableWidthData.class);
    public static final int MIN_CHUNK_SIZE = 1024;
    public static final int MAX_CHUNK_SIZE = 0x800000;
    private static final int DOUBLING_CHUNK_THRESHOLD = 524288;
    public static final int POINTER_SIZE = 8;
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private static final byte[] EMPTY_CHUNK = VariableWidthData.EMPTY_CHUNK;
    private final ObjectArrayList<byte[]> chunks = new ObjectArrayList();
    private int openChunkOffset;
    private long chunksRetainedSizeInBytes;
    private long allocatedBytes;
    private long freeBytes;

    public AppendOnlyVariableWidthData() {
    }

    public AppendOnlyVariableWidthData(AppendOnlyVariableWidthData other) {
        for (byte[] chunk : other.chunks) {
            this.chunks.add((Object)Arrays.copyOf(chunk, chunk.length));
        }
        this.openChunkOffset = other.openChunkOffset;
        this.chunksRetainedSizeInBytes = other.chunksRetainedSizeInBytes;
        this.allocatedBytes = other.allocatedBytes;
        this.freeBytes = other.freeBytes;
    }

    public long getRetainedSizeBytes() {
        return Math.addExact((long)INSTANCE_SIZE, Math.addExact(this.chunksRetainedSizeInBytes, SizeOf.sizeOf((Object[])this.chunks.elements())));
    }

    public List<byte[]> getAllChunks() {
        return this.chunks;
    }

    public long getAllocatedBytes() {
        return this.allocatedBytes;
    }

    public long getFreeBytes() {
        return this.freeBytes;
    }

    public byte[] allocate(byte[] pointer, int pointerOffset, int size) {
        byte[] openChunk;
        if (size == 0) {
            AppendOnlyVariableWidthData.writePointer(pointer, pointerOffset, 0, 0);
            return EMPTY_CHUNK;
        }
        byte[] byArray = openChunk = this.chunks.isEmpty() ? EMPTY_CHUNK : (byte[])this.chunks.getLast();
        if (openChunk.length - this.openChunkOffset < size) {
            this.freeBytes += (long)(openChunk.length - this.openChunkOffset);
            int newSize = Ints.saturatedCast((long)Math.max((long)size * 32L, AppendOnlyVariableWidthData.nextChunkSize(openChunk.length)));
            newSize = Math.clamp((long)newSize, 1024, 0x800000);
            newSize = Math.max(newSize, size);
            openChunk = new byte[newSize];
            this.chunks.add((Object)openChunk);
            this.allocatedBytes += (long)newSize;
            this.chunksRetainedSizeInBytes = Math.addExact(this.chunksRetainedSizeInBytes, SizeOf.sizeOf((byte[])openChunk));
            this.openChunkOffset = 0;
        }
        AppendOnlyVariableWidthData.writePointer(pointer, pointerOffset, this.chunks.size() - 1, this.openChunkOffset);
        this.openChunkOffset += size;
        return openChunk;
    }

    public byte[] getChunk(byte[] pointer, int pointerOffset) {
        int chunkIndex = AppendOnlyVariableWidthData.getChunkIndex(pointer, pointerOffset);
        if (this.chunks.isEmpty()) {
            Verify.verify((chunkIndex == 0 ? 1 : 0) != 0);
            return EMPTY_CHUNK;
        }
        Objects.checkIndex(chunkIndex, this.chunks.size());
        return (byte[])this.chunks.get(chunkIndex);
    }

    private static long nextChunkSize(long previousChunkSize) {
        if (previousChunkSize < 524288L) {
            return previousChunkSize * 2L;
        }
        return previousChunkSize + (previousChunkSize >> 1);
    }

    private static int getChunkIndex(byte[] pointer, int pointerOffset) {
        return INT_HANDLE.get(pointer, pointerOffset);
    }

    public static int getChunkOffset(byte[] pointer, int pointerOffset) {
        return INT_HANDLE.get(pointer, pointerOffset + 4);
    }

    public static void writePointer(byte[] pointer, int pointerOffset, int chunkIndex, int chunkOffset) {
        INT_HANDLE.set(pointer, pointerOffset, chunkIndex);
        INT_HANDLE.set(pointer, pointerOffset + 4, chunkOffset);
    }
}

