/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.DriverContext;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.MarkDistinctHash;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MarkDistinctOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final MarkDistinctHash markDistinctHash;
    private final LocalMemoryContext localUserMemoryContext;
    private final int[] markDistinctChannels;
    private Page inputPage;
    private boolean finishing;
    private Work<Block> unfinishedWork;

    public MarkDistinctOperator(OperatorContext operatorContext, List<Type> types, List<Integer> markDistinctChannels, Optional<Integer> hashChannel, FlatHashStrategyCompiler hashStrategyCompiler) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        Objects.requireNonNull(hashChannel, "hashChannel is null");
        Objects.requireNonNull(markDistinctChannels, "markDistinctChannels is null");
        ImmutableList.Builder distinctTypes = ImmutableList.builder();
        for (int channel : markDistinctChannels) {
            distinctTypes.add((Object)types.get(channel));
        }
        if (hashChannel.isPresent()) {
            this.markDistinctChannels = new int[markDistinctChannels.size() + 1];
            for (int i = 0; i < markDistinctChannels.size(); ++i) {
                this.markDistinctChannels[i] = markDistinctChannels.get(i);
            }
            this.markDistinctChannels[markDistinctChannels.size()] = hashChannel.get();
        } else {
            this.markDistinctChannels = Ints.toArray(markDistinctChannels);
        }
        this.markDistinctHash = new MarkDistinctHash(operatorContext.getSession(), (List<Type>)distinctTypes.build(), hashChannel.isPresent(), hashStrategyCompiler, this::updateMemoryReservation);
        this.localUserMemoryContext = operatorContext.localUserMemoryContext();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && !this.hasUnfinishedInput();
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && !this.hasUnfinishedInput();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((boolean)this.needsInput());
        this.inputPage = page;
        this.unfinishedWork = this.markDistinctHash.markDistinctRows(page.getColumns(this.markDistinctChannels));
        this.updateMemoryReservation();
    }

    @Override
    public Page getOutput() {
        if (this.unfinishedWork == null) {
            return null;
        }
        if (!this.unfinishedWork.process()) {
            return null;
        }
        Page outputPage = this.inputPage.appendColumn(this.unfinishedWork.getResult());
        this.unfinishedWork = null;
        this.inputPage = null;
        this.updateMemoryReservation();
        return outputPage;
    }

    private boolean hasUnfinishedInput() {
        return this.inputPage != null || this.unfinishedWork != null;
    }

    private boolean updateMemoryReservation() {
        this.localUserMemoryContext.setBytes(this.markDistinctHash.getEstimatedSize());
        return this.operatorContext.isWaitingForMemory().isDone();
    }

    @VisibleForTesting
    public int getCapacity() {
        return this.markDistinctHash.getCapacity();
    }

    public static class MarkDistinctOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Optional<Integer> hashChannel;
        private final List<Integer> markDistinctChannels;
        private final List<Type> types;
        private final FlatHashStrategyCompiler hashStrategyCompiler;
        private boolean closed;

        public MarkDistinctOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> sourceTypes, Collection<Integer> markDistinctChannels, Optional<Integer> hashChannel, FlatHashStrategyCompiler hashStrategyCompiler) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.markDistinctChannels = ImmutableList.copyOf(Objects.requireNonNull(markDistinctChannels, "markDistinctChannels is null"));
            Preconditions.checkArgument((!markDistinctChannels.isEmpty() ? 1 : 0) != 0, (Object)"markDistinctChannels is empty");
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            this.hashStrategyCompiler = Objects.requireNonNull(hashStrategyCompiler, "hashStrategyCompiler is null");
            this.types = ImmutableList.builder().addAll(sourceTypes).add((Object)BooleanType.BOOLEAN).build();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, MarkDistinctOperator.class.getSimpleName());
            return new MarkDistinctOperator(operatorContext, this.types, this.markDistinctChannels, this.hashChannel, this.hashStrategyCompiler);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new MarkDistinctOperatorFactory(this.operatorId, this.planNodeId, this.types.subList(0, this.types.size() - 1), this.markDistinctChannels, this.hashChannel, this.hashStrategyCompiler);
        }
    }
}

