/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.AggregationMetrics;
import io.trino.operator.Work;
import java.util.Objects;

public class MeasuredGroupByHashWork<T>
implements Work<T> {
    private final Work<T> delegate;
    private final AggregationMetrics metrics;

    public MeasuredGroupByHashWork(Work<T> delegate, AggregationMetrics metrics) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.metrics = Objects.requireNonNull(metrics, "metrics is null");
    }

    @Override
    public boolean process() {
        long start = System.nanoTime();
        boolean result = this.delegate.process();
        this.metrics.recordGroupByHashUpdateTimeSince(start);
        return result;
    }

    @Override
    public T getResult() {
        return this.delegate.getResult();
    }
}

